/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.views;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.management.ContextStateMapper;
import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedComponent;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher;
import org.jboss.profileservice.management.ManagedOperationProxyFactory;
import org.jboss.profileservice.management.views.AbstractManagedDeploymentView;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProfileView
extends AbstractManagedDeploymentView {
    private static final Logger log = Logger.getLogger(AbstractProfileView.class);
    private static final ContextStateMapper<RunState> runStateMapper;
    private static final ContextStateMapper<DeploymentState> deploymentStateMapper;
    private RuntimeComponentDispatcher dispatcher;
    private ManagedOperationProxyFactory proxyFactory;

    public AbstractProfileView(ManagedOperationProxyFactory proxyFactory) {
        if (proxyFactory == null) {
            throw new IllegalArgumentException("null proxy factory");
        }
        if (proxyFactory.getDispatcher() == null) {
            throw new IllegalArgumentException("null runtime component dispatcher");
        }
        this.proxyFactory = proxyFactory;
        this.dispatcher = proxyFactory.getDispatcher();
    }

    public abstract boolean hasBeenModified(Profile var1);

    public abstract ProfileKey getProfileKey();

    protected void processRootManagedDeployment(ManagedDeployment md, boolean trace) throws Exception {
        DeploymentState state = this.getDeploymentState(md);
        this.processManagedDeployment(md, state, 0, trace);
    }

    @Override
    protected void mergeRuntimeMO(ManagedObject mo, ManagedObject runtimeMO) throws Exception {
        Map runtimeProps = runtimeMO.getProperties();
        Set<ManagedOperation> runtimeOps = runtimeMO.getOperations();
        Object componentName = runtimeMO.getComponentName();
        log.debug((Object)("Merging runtime: " + runtimeMO.getName() + ", compnent name: " + componentName));
        Map moProps = null;
        Set moOps = null;
        HashMap<String, ManagedProperty> props = null;
        HashSet<ManagedOperation> ops = null;
        if (mo == null) {
            mo = runtimeMO;
            moProps = mo.getProperties();
            moOps = mo.getOperations();
            props = new HashMap();
            ops = new HashSet<ManagedOperation>();
        } else {
            moProps = mo.getProperties();
            moOps = mo.getOperations();
            props = new HashMap<String, ManagedProperty>(moProps);
            ops = new HashSet(moOps);
        }
        if (runtimeProps != null && runtimeProps.size() > 0) {
            log.debug((Object)("Properties before:" + props));
            for (ManagedProperty prop : runtimeProps.values()) {
                if (prop.hasViewUse(ViewUse.STATISTIC)) {
                    String propName = prop.getMappedName();
                    try {
                        AbstractRuntimeComponentDispatcher.setActiveProperty(prop);
                        MetaValue propValue = this.dispatcher.get(componentName, propName);
                        if (propValue != null) {
                            prop.setValue(propValue);
                        }
                    }
                    catch (Throwable t) {
                        log.debug((Object)("Failed to get stat value, " + componentName + ":" + propName));
                    }
                    ManagedProperty proxiedProp = this.createPropertyProxy(prop);
                    props.put(prop.getName(), proxiedProp);
                } else {
                    props.put(prop.getName(), prop);
                }
                if (prop.getTargetManagedObject() != null) continue;
                prop.setTargetManagedObject(runtimeMO);
            }
            log.debug((Object)("Properties after:" + props));
        }
        if (runtimeOps != null && runtimeOps.size() > 0) {
            log.debug((Object)("Ops before:" + ops));
            runtimeOps = this.createOperationProxies(runtimeMO, runtimeOps);
            ops.addAll(runtimeOps);
            log.debug((Object)("Ops after:" + ops));
        }
        MutableManagedObject moi = (MutableManagedObject)mo;
        moi.setProperties(props);
        moi.setOperations(ops);
    }

    @Override
    protected Set<ManagedOperation> createOperationProxies(ManagedObject mo, Set<ManagedOperation> ops) throws Exception {
        if (this.proxyFactory == null) {
            throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
        }
        Object componentName = mo.getComponentName();
        return this.createOperationProxies(ops, componentName);
    }

    protected Set<ManagedOperation> createOperationProxies(Set<ManagedOperation> ops, Object componentName) throws Exception {
        return this.proxyFactory.createOperationProxies(ops, componentName);
    }

    private ManagedProperty createPropertyProxy(ManagedProperty prop) throws Exception {
        if (this.proxyFactory == null) {
            throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
        }
        Object componentName = prop.getManagedObject().getComponentName();
        return this.proxyFactory.createPropertyProxy(prop, componentName);
    }

    @Override
    protected RunState updateRunState(ManagedObject runtimeMO, ManagedComponent comp) {
        RunState state = comp.getRunState();
        if (state == RunState.UNKNOWN && this.dispatcher != null) {
            Object name = comp.getComponentName();
            if (name == null && runtimeMO != null) {
                name = runtimeMO.getComponentName();
            }
            if (name != null) {
                state = this.getMappedState(name, runStateMapper);
                if (comp instanceof MutableManagedComponent) {
                    MutableManagedComponent mcomp = (MutableManagedComponent)MutableManagedComponent.class.cast(comp);
                    mcomp.setRunState(state);
                }
            }
        }
        return state;
    }

    protected DeploymentState getDeploymentState(ManagedDeployment md) {
        String name;
        DeploymentState state = md.getDeploymentState();
        if (state == DeploymentState.UNKNOWN && this.dispatcher != null && (name = md.getName()) != null) {
            state = this.getMappedState(name, deploymentStateMapper);
        }
        return state;
    }

    protected <T extends Enum<?>> T getMappedState(Object name, ContextStateMapper<T> mapper) {
        Enum state = null;
        if (this.dispatcher != null) {
            try {
                AbstractRuntimeComponentDispatcher xdispatcher = (AbstractRuntimeComponentDispatcher)this.dispatcher;
                state = xdispatcher.mapControllerState(name, mapper);
            }
            catch (Exception e) {
                state = mapper.getErrorState();
            }
        }
        return (T)state;
    }

    static {
        HashMap<String, RunState> runStateMappings = new HashMap<String, RunState>();
        runStateMappings.put("**ERROR**", RunState.FAILED);
        runStateMappings.put("Not Installed", RunState.STOPPED);
        runStateMappings.put("PreInstall", RunState.STOPPED);
        runStateMappings.put("Described", RunState.STOPPED);
        runStateMappings.put("Instantiated", RunState.STOPPED);
        runStateMappings.put("Configured", RunState.STOPPED);
        runStateMappings.put("Create", RunState.STOPPED);
        runStateMappings.put("Start", RunState.STOPPED);
        runStateMappings.put("Installed", RunState.RUNNING);
        runStateMapper = new ContextStateMapper(runStateMappings, (Enum)RunState.STARTING, (Enum)RunState.STOPPED, (Enum)RunState.FAILED, (Enum)RunState.UNKNOWN);
        HashMap<String, DeploymentState> deploymentMappings = new HashMap<String, DeploymentState>();
        deploymentMappings.put("**ERROR**", DeploymentState.FAILED);
        deploymentMappings.put("Not Installed", DeploymentState.STOPPED);
        deploymentMappings.put("Installed", DeploymentState.STARTED);
        deploymentStateMapper = new ContextStateMapper(deploymentMappings, (Enum)DeploymentState.STARTING, (Enum)DeploymentState.STOPPING, (Enum)DeploymentState.FAILED, (Enum)DeploymentState.UNKNOWN);
    }
}

