/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.metadata;

import java.util.ArrayList;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.WebservicesMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PortComponentSpec;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;

public class EJBArchiveMetaDataAdapterEJB3 {
    private static Logger log = Logger.getLogger(EJBArchiveMetaDataAdapterEJB3.class);

    public EJBArchiveMetaData buildMetaData(Deployment dep, DeploymentUnit unit) {
        EJBArchiveMetaData umd = new EJBArchiveMetaData();
        WebServiceDeployment webServiceDeployment = (WebServiceDeployment)dep.getAttachment(WebServiceDeployment.class);
        this.buildEnterpriseBeansMetaData(umd, webServiceDeployment);
        JBossMetaData jbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (jbMetaData != null) {
            this.buildWebservicesMetaData(umd, jbMetaData);
        }
        return umd;
    }

    private void buildWebservicesMetaData(EJBArchiveMetaData ejbMetaData, JBossMetaData jbMetaData) {
        WebservicesMetaData wsMetaData = jbMetaData.getWebservices();
        if (wsMetaData != null) {
            String contextRoot = wsMetaData.getContextRoot();
            ejbMetaData.setWebServiceContextRoot(contextRoot);
            ejbMetaData.setPublishLocationAdapter(this.getPublishLocationAdpater(wsMetaData));
            WebserviceDescriptionsMetaData wsDescriptions = wsMetaData.getWebserviceDescriptions();
            if (wsDescriptions != null) {
                if (wsDescriptions.size() > 1) {
                    log.warn((Object)"Multiple <webservice-description> elements not supported");
                }
                if (wsDescriptions.size() > 0) {
                    WebserviceDescriptionMetaData wsd = (WebserviceDescriptionMetaData)wsDescriptions.iterator().next();
                    ejbMetaData.setConfigName(wsd.getConfigName());
                    ejbMetaData.setConfigFile(wsd.getConfigFile());
                }
            }
        }
    }

    private void buildEnterpriseBeansMetaData(EJBArchiveMetaData jarMetaData, WebServiceDeployment ejb3Deployment) {
        ArrayList<MDBMetaData> ejbMetaDataList = new ArrayList<MDBMetaData>();
        for (WebServiceDeclaration container : ejb3Deployment.getServiceEndpoints()) {
            PortComponentSpec pcMetaData = (PortComponentSpec)container.getAnnotation(PortComponentSpec.class);
            MessageDriven mdbMetaData = (MessageDriven)container.getAnnotation(MessageDriven.class);
            MDBMetaData ejbMetaData = null;
            if (mdbMetaData != null) {
                String destination;
                ejbMetaData = new MDBMetaData();
                ActivationConfigProperty[] props = mdbMetaData.activationConfig();
                if (props != null && (destination = this.getActivationProperty("destination", props)) != null) {
                    ejbMetaData.setDestinationJndiName(destination);
                }
            } else {
                ejbMetaData = new SLSBMetaData();
            }
            if (ejbMetaData == null) continue;
            ejbMetaData.setEjbName(container.getComponentName());
            ejbMetaData.setEjbClass(container.getComponentClassName());
            if (pcMetaData != null) {
                ejbMetaData.setPortComponentName(pcMetaData.portComponentName());
                ejbMetaData.setPortComponentURI(pcMetaData.portComponentURI());
                EJBSecurityMetaData smd = new EJBSecurityMetaData();
                smd.setAuthMethod(pcMetaData.authMethod());
                smd.setTransportGuarantee(pcMetaData.transportGuarantee());
                smd.setSecureWSDLAccess(Boolean.valueOf(pcMetaData.secureWSDLAccess()));
                ejbMetaData.setSecurityMetaData(smd);
            }
            ejbMetaDataList.add(ejbMetaData);
        }
        jarMetaData.setEnterpriseBeans(ejbMetaDataList);
    }

    private String getActivationProperty(String name, ActivationConfigProperty[] props) {
        String result = null;
        for (ActivationConfigProperty p : props) {
            if (!p.propertyName().equals(name)) continue;
            result = p.propertyValue();
            break;
        }
        return result;
    }

    private EJBArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final WebservicesMetaData wsMetaData) {
        return new EJBArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                String wsdlPublishLocation = null;
                WebserviceDescriptionsMetaData wsDescriptions = wsMetaData.getWebserviceDescriptions();
                if (wsDescriptions != null && wsDescriptions.get(name) != null) {
                    WebserviceDescriptionMetaData wsdMetaData = (WebserviceDescriptionMetaData)wsDescriptions.get(name);
                    wsdlPublishLocation = wsdMetaData.getWsdlPublishLocation();
                }
                return wsdlPublishLocation;
            }
        };
    }
}

