/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.NotSerializableException;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.RPCManager;
import org.jboss.cache.RPCManagerImpl;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.remote.AnnounceBuddyPoolNameCommand;
import org.jboss.cache.commands.remote.AssignToBuddyGroupCommand;
import org.jboss.cache.commands.remote.RemoveFromBuddyGroupCommand;
import org.jboss.cache.commands.remote.StateTransferControlCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.marshall.ExtendedResponse;
import org.jboss.cache.marshall.ReplicationObserver;
import org.jboss.cache.marshall.RequestIgnoredResponse;
import org.jboss.cache.util.concurrent.BoundedExecutors;
import org.jboss.cache.util.concurrent.WithinThreadExecutor;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandAwareRpcDispatcher
extends RpcDispatcher {
    protected InvocationContextContainer invocationContextContainer;
    protected InterceptorChain interceptorChain;
    protected ComponentRegistry componentRegistry;
    protected boolean trace;
    private ExecutorService replicationProcessor;
    private AtomicInteger replicationProcessorCount;
    private boolean asyncSerial;
    private Configuration configuration;
    private RPCManager rpcManager;
    private ReplicationObserver replicationObserver;

    public CommandAwareRpcDispatcher() {
    }

    public CommandAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object serverObj, InvocationContextContainer container, InterceptorChain interceptorChain, ComponentRegistry componentRegistry, RPCManager manager) {
        super(channel, l, l2, serverObj);
        Configuration c;
        this.invocationContextContainer = container;
        this.componentRegistry = componentRegistry;
        this.interceptorChain = interceptorChain;
        this.rpcManager = manager;
        this.trace = this.log.isTraceEnabled();
        this.configuration = c = componentRegistry.getComponent(Configuration.class);
        this.replicationProcessor = c.getRuntimeConfig().getAsyncSerializationExecutor();
        if (c.getCacheMode().isSynchronous() || this.replicationProcessor == null && c.getSerializationExecutorPoolSize() < 1 || this.requireSyncMarshalling(c)) {
            this.replicationProcessor = new WithinThreadExecutor();
            this.asyncSerial = false;
        } else {
            this.asyncSerial = true;
            if (this.replicationProcessor == null) {
                this.replicationProcessorCount = new AtomicInteger(0);
                this.replicationProcessor = BoundedExecutors.newFixedThreadPool(c.isUseReplQueue() ? 1 : c.getSerializationExecutorPoolSize(), new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        return new Thread(r, "AsyncReplicationProcessor-" + CommandAwareRpcDispatcher.this.replicationProcessorCount.incrementAndGet());
                    }
                }, c.getSerializationExecutorQueueSize());
            }
        }
    }

    public ReplicationObserver setReplicationObserver(ReplicationObserver replicationObserver) {
        ReplicationObserver result = this.replicationObserver;
        this.replicationObserver = replicationObserver;
        return result;
    }

    private boolean requireSyncMarshalling(Configuration c) {
        boolean enforceSerialMarshalling;
        boolean bl = enforceSerialMarshalling = c.getNodeLockingScheme().equals((Object)Configuration.NodeLockingScheme.OPTIMISTIC) && !c.getCacheMode().isInvalidation();
        if (enforceSerialMarshalling) {
            if (c.getSerializationExecutorPoolSize() > 1 && this.log.isWarnEnabled()) {
                this.log.warn((Object)"Async optimistic caches do not support serialization pools.");
            }
            if (this.trace) {
                this.log.trace((Object)"Disbaling serial marshalling for opt async cache");
            }
        }
        return enforceSerialMarshalling;
    }

    public void stop() {
        this.replicationProcessor.shutdownNow();
        try {
            this.replicationProcessor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.stop();
    }

    protected boolean isValid(Message req) {
        if (this.server_obj == null) {
            this.log.error((Object)"no method handler is registered. Discarding request.");
            return false;
        }
        if (req == null || req.getLength() == 0) {
            this.log.error((Object)"message or message buffer is null");
            return false;
        }
        return true;
    }

    public RspList invokeRemoteCommands(Vector<Address> dests, ReplicableCommand command, int mode, long timeout, boolean anycasting, boolean oob, RspFilter filter) throws NotSerializableException, ExecutionException, InterruptedException {
        if (dests != null && dests.isEmpty()) {
            if (this.trace) {
                this.log.trace((Object)"Destination list is empty: no need to send message");
            }
            return new RspList();
        }
        if (this.trace) {
            this.log.trace((Object)new StringBuilder("dests=").append(dests).append(", command=").append(command).append(", mode=").append(mode).append(", timeout=").append(timeout));
        }
        boolean supportReplay = this.configuration.isNonBlockingStateTransfer();
        ReplicationTask replicationTask = new ReplicationTask(command, oob, dests, mode, timeout, anycasting, supportReplay, filter);
        Future<RspList> response = this.replicationProcessor.submit(replicationTask);
        if (this.asyncSerial) {
            return null;
        }
        RspList retval = response.get();
        if (retval.isEmpty() || this.containsOnlyNulls(retval)) {
            return null;
        }
        return retval;
    }

    private boolean containsOnlyNulls(RspList l) {
        for (Rsp r : l.values()) {
            if (r.getValue() == null && r.wasReceived() && !r.wasSuspected()) continue;
            return false;
        }
        return true;
    }

    public Object handle(Message req) {
        if (this.isValid(req)) {
            try {
                ReplicableCommand command = (ReplicableCommand)this.req_marshaller.objectFromByteBuffer(req.getBuffer(), req.getOffset(), req.getLength());
                Object execResult = this.executeCommand(command, req);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Command : " + command + " executed, result is: " + execResult));
                }
                return execResult;
            }
            catch (Throwable x) {
                if (this.trace) {
                    this.log.trace((Object)"Problems invoking command.", x);
                }
                return x;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeCommand(ReplicableCommand cmd, Message req) throws Throwable {
        boolean unlock = false;
        RPCManagerImpl.FlushTracker flushTracker = this.rpcManager.getFlushTracker();
        try {
            Object ret;
            if (cmd == null) {
                throw new NullPointerException("Unable to execute a null command!  Message was " + req);
            }
            if (this.trace) {
                this.log.trace((Object)("Executing command: " + cmd + " [sender=" + req.getSrc() + "]"));
            }
            boolean replayIgnored = false;
            if (this.configuration.isNonBlockingStateTransfer() && !(cmd instanceof StateTransferControlCommand)) {
                int flushCount = flushTracker.getFlushCompletionCount();
                flushTracker.lockProcessingLock();
                unlock = true;
                flushTracker.waitForFlushCompletion(this.configuration.getStateRetrievalTimeout());
                boolean bl = replayIgnored = flushTracker.getFlushCompletionCount() != flushCount;
            }
            if (cmd instanceof VisitableCommand) {
                InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
                ctx.setOriginLocal(false);
                if (!this.componentRegistry.invocationsAllowed(false)) {
                    RequestIgnoredResponse requestIgnoredResponse = new RequestIgnoredResponse();
                    return requestIgnoredResponse;
                }
                ret = this.interceptorChain.invoke(ctx, (VisitableCommand)cmd);
            } else {
                if (this.trace) {
                    this.log.trace((Object)"This is a non-visitable command - so performing directly and not via the invoker.");
                }
                if (this.requiresRunningCache(cmd) && !this.componentRegistry.invocationsAllowed(false)) {
                    RequestIgnoredResponse ctx = new RequestIgnoredResponse();
                    return ctx;
                }
                ret = cmd.perform(null);
            }
            if (replayIgnored) {
                ExtendedResponse extended = new ExtendedResponse(ret);
                extended.setReplayIgnoredRequests(true);
                ret = extended;
            }
            Object object = ret;
            return object;
        }
        finally {
            if (this.replicationObserver != null) {
                this.replicationObserver.afterExecutingCommand(cmd);
            }
            if (unlock) {
                flushTracker.unlockProcessingLock();
            }
        }
    }

    private boolean requiresRunningCache(ReplicableCommand cmd) {
        return !(cmd instanceof AnnounceBuddyPoolNameCommand) && !(cmd instanceof AssignToBuddyGroupCommand) && !(cmd instanceof RemoveFromBuddyGroupCommand) && !(cmd instanceof StateTransferControlCommand);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Outgoing marshaller: " + this.req_marshaller + "; incoming marshaller: " + this.rsp_marshaller + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplicationTask
    implements Callable<RspList> {
        private ReplicableCommand command;
        private boolean oob;
        private Vector<Address> dests;
        private int mode;
        private long timeout;
        private boolean anycasting;
        private boolean supportReplay;
        private RspFilter filter;

        private ReplicationTask(ReplicableCommand command, boolean oob, Vector<Address> dests, int mode, long timeout, boolean anycasting, boolean supportReplay, RspFilter filter) {
            this.command = command;
            this.oob = oob;
            this.dests = dests;
            this.mode = mode;
            this.timeout = timeout;
            this.anycasting = anycasting;
            this.supportReplay = supportReplay;
            this.filter = filter;
        }

        @Override
        public RspList call() throws Exception {
            Buffer buf;
            try {
                buf = CommandAwareRpcDispatcher.this.req_marshaller.objectToBuffer((Object)this.command);
            }
            catch (Exception e) {
                if (CommandAwareRpcDispatcher.this.log.isErrorEnabled()) {
                    CommandAwareRpcDispatcher.this.log.error((Object)e);
                }
                throw new RuntimeException("Failure to marshal argument(s)", e);
            }
            Message msg = new Message();
            msg.setBuffer(buf);
            if (this.oob) {
                msg.setFlag((byte)1);
            }
            int mode = this.supportReplay ? 2 : this.mode;
            RspList retval = CommandAwareRpcDispatcher.this.castMessage(this.dests, msg, mode, this.timeout, this.anycasting, this.filter);
            if (CommandAwareRpcDispatcher.this.trace) {
                CommandAwareRpcDispatcher.this.log.trace((Object)("responses: " + retval));
            }
            if (retval == null) {
                throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + this.command.getClass().getSimpleName() + " not being serializable.");
            }
            if (this.supportReplay) {
                boolean replay = false;
                Vector ignorers = new Vector();
                for (Map.Entry entry : retval.entrySet()) {
                    Object value = ((Rsp)entry.getValue()).getValue();
                    if (value instanceof RequestIgnoredResponse) {
                        ignorers.add(entry.getKey());
                        continue;
                    }
                    if (!(value instanceof ExtendedResponse)) continue;
                    ExtendedResponse extended = (ExtendedResponse)value;
                    replay |= extended.isReplayIgnoredRequests();
                    ((Rsp)entry.getValue()).setValue(extended.getResponse());
                }
                if (replay && ignorers.size() > 0) {
                    RspList responses;
                    if (CommandAwareRpcDispatcher.this.trace) {
                        CommandAwareRpcDispatcher.this.log.trace((Object)("Replaying message to ignoring senders: " + ignorers));
                    }
                    if ((responses = CommandAwareRpcDispatcher.this.castMessage(ignorers, msg, 2, this.timeout, this.anycasting, this.filter)) != null) {
                        retval.putAll((Map)responses);
                    }
                }
            }
            return retval;
        }
    }
}

