/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version {
    public static final String VERSION_MAJOR = "version.major";
    public static final String VERSION_MINOR = "version.minor";
    public static final String VERSION_REVISION = "version.revision";
    public static final String VERSION_TAG = "version.tag";
    public static final String VERSION_NAME = "version.name";
    public static final String VERSION_CVSTAG = "version.cvstag";
    public static final String BUILD_NUMBER = "build.number";
    public static final String BUILD_ID = "build.id";
    public static final String BUILD_DATE = "build.day";
    public static final String BUILD_JVM_VERSION = "java.vm.version";
    public static final String BUILD_JVM_VENDOR = "java.vendor";
    public static final String BUILD_OS = "os.name";
    public static final String BUILD_OS_ARCH = "os.arch";
    public static final String BUILD_OS_VERSION = "os.version";
    private static Version instance = null;
    private Properties props = this.loadProperties();

    private Version() {
    }

    public static Version getInstance() {
        if (instance == null) {
            instance = new Version();
        }
        return instance;
    }

    public Map<Object, Object> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public int getMajor() {
        return this.getIntProperty(VERSION_MAJOR);
    }

    public int getMinor() {
        return this.getIntProperty(VERSION_MINOR);
    }

    public int getRevision() {
        return this.getIntProperty(VERSION_REVISION);
    }

    public String getTag() {
        return this.props.getProperty(VERSION_TAG);
    }

    public String getCvsTag() {
        return this.props.getProperty(VERSION_CVSTAG);
    }

    public String getName() {
        return this.props.getProperty(VERSION_NAME);
    }

    public String getBuildID() {
        return this.props.getProperty(BUILD_ID);
    }

    public String getBuildNumber() {
        return this.props.getProperty(BUILD_NUMBER);
    }

    public String getBuildDate() {
        return this.props.getProperty(BUILD_DATE);
    }

    public String getBuildJVM() {
        String vm = this.props.getProperty(BUILD_JVM_VERSION);
        String vendor = this.props.getProperty(BUILD_JVM_VENDOR);
        return vm + '(' + vendor + ')';
    }

    public String getBuildOS() {
        String os = this.props.getProperty(BUILD_OS);
        String arch = this.props.getProperty(BUILD_OS_ARCH);
        String version = this.props.getProperty(BUILD_OS_VERSION);
        return os + '(' + arch + ',' + version + ')';
    }

    public String getVersionNumber() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getMajor()).append(".");
        buff.append(this.getMinor()).append(".");
        buff.append(this.getRevision()).append(".");
        buff.append(this.getTag());
        return buff.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getVersionNumber());
        buff.append(" (build: SVNTag=");
        buff.append(this.getCvsTag());
        buff.append(" date=");
        buff.append(this.getBuildID());
        buff.append(")");
        return buff.toString();
    }

    private int getIntProperty(String name) {
        try {
            return Integer.valueOf(this.props.getProperty(name));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private Properties loadProperties() {
        this.props = new Properties();
        try {
            InputStream in = Version.class.getResourceAsStream("/org/jboss/version.properties");
            if (in != null) {
                this.props.load(in);
                in.close();
            }
        }
        catch (IOException e) {
            throw new Error("Missing version.properties");
        }
        return this.props;
    }
}

