/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.iiop.rmi.ContainerAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.logging.Logger;

class WorkCacheManager {
    private static final Logger logger = Logger.getLogger(WorkCacheManager.class);
    Constructor constructor;
    Method initializer;
    Map workDone;
    Map workInProgress;

    WorkCacheManager(Class cls) {
        logger.debug((Object)("Class: " + cls.getName()));
        try {
            this.constructor = cls.getDeclaredConstructor(Class.class);
            this.initializer = cls.getDeclaredMethod("doAnalyze", null);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Bad Class: " + ex.toString());
        }
        this.workDone = new WeakHashMap();
        this.workInProgress = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerAnalysis getAnalysis(Class cls) throws RMIIIOPViolationException {
        ContainerAnalysis ret;
        WorkCacheManager workCacheManager = this;
        synchronized (workCacheManager) {
            ret = this.lookupDone(cls);
            if (ret != null) {
                return ret;
            }
            InProgress inProgress = (InProgress)this.workInProgress.get(cls);
            if (inProgress != null && inProgress.thread == Thread.currentThread()) {
                return inProgress.analysis;
            }
            ret = this.createWorkInProgress(cls);
        }
        this.doTheWork(cls, ret);
        workCacheManager = this;
        synchronized (workCacheManager) {
            this.workInProgress.remove(cls);
            this.workDone.put(cls, new SoftReference<ContainerAnalysis>(ret));
            this.notifyAll();
        }
        return ret;
    }

    private ContainerAnalysis lookupDone(Class cls) {
        SoftReference ref = (SoftReference)this.workDone.get(cls);
        if (ref == null) {
            return null;
        }
        ContainerAnalysis ret = (ContainerAnalysis)ref.get();
        if (ret == null) {
            this.workDone.remove(cls);
        }
        return ret;
    }

    private ContainerAnalysis createWorkInProgress(Class cls) {
        ContainerAnalysis analysis;
        try {
            analysis = (ContainerAnalysis)this.constructor.newInstance(cls);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.toString());
        }
        this.workInProgress.put(cls, new InProgress(analysis, Thread.currentThread()));
        return analysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTheWork(Class cls, ContainerAnalysis ret) throws RMIIIOPViolationException {
        try {
            this.initializer.invoke((Object)ret, new Object[0]);
        }
        catch (Throwable t) {
            WorkCacheManager workCacheManager = this;
            synchronized (workCacheManager) {
                this.workInProgress.remove(cls);
            }
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof RMIIIOPViolationException) {
                throw (RMIIIOPViolationException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t.toString());
        }
    }

    private static class InProgress {
        ContainerAnalysis analysis;
        Thread thread;

        InProgress(ContainerAnalysis analysis, Thread thread) {
            this.analysis = analysis;
            this.thread = thread;
        }
    }
}

