/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.Scope;

public class AspectDefinition {
    protected String name;
    protected Scope scope = Scope.PER_VM;
    protected AspectFactory factory;
    protected boolean deployed = true;
    public Map<Advisor, Boolean> advisors = new WeakHashMap<Advisor, Boolean>();

    public AspectDefinition(String name, Scope scope, AspectFactory factory) {
        this.name = name;
        this.scope = scope;
        this.factory = factory;
        if (this.scope == null) {
            this.scope = Scope.PER_VM;
        }
        if (this.name == null) {
            this.name = this.factory.getName();
        }
    }

    public AspectDefinition() {
    }

    public synchronized void undeploy() {
        if (this.advisors.size() > 0) {
            Iterator<Advisor> it = this.advisors.keySet().iterator();
            while (it.hasNext()) {
                Advisor advisor = it.next();
                if (advisor == null) continue;
                it.remove();
                if (this.scope == Scope.PER_INSTANCE) {
                    advisor.removePerInstanceAspect(this);
                    continue;
                }
                if (this.scope == Scope.PER_JOINPOINT) {
                    advisor.removePerInstanceJoinpointAspect(this);
                    continue;
                }
                if (this.scope == Scope.PER_CLASS) {
                    advisor.removePerClassAspect(this);
                    if (!(advisor instanceof GeneratedClassAdvisor)) continue;
                    ((GeneratedClassAdvisor)advisor).removePerClassJoinpointAspect(this);
                    continue;
                }
                if (this.scope != Scope.PER_CLASS_JOINPOINT || !(advisor instanceof GeneratedClassAdvisor)) continue;
                ((GeneratedClassAdvisor)advisor).removePerClassJoinpointAspect(this);
            }
            this.advisors.clear();
        }
        this.deployed = false;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setFactory(AspectFactory factory) {
        this.factory = factory;
    }

    public AspectFactory getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void registerAdvisor(Advisor advisor) {
        this.advisors.put(advisor, Boolean.TRUE);
    }

    public synchronized void unregisterAdvisor(Advisor advisor) {
        this.advisors.remove(advisor);
    }

    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AspectDefinition)) {
            return false;
        }
        return this.name.equals(((AspectDefinition)obj).name);
    }
}

