/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Property;

@DiscriminatorValue(value="property")
@Entity
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class PropertySimple
extends Property
implements Externalizable {
    public static final int MAX_VALUE_LENGTH = 2000;
    private static final long serialVersionUID = 1L;
    @Column(name="override")
    private Boolean override;
    @Column(name="string_value", length=2000)
    private String stringValue;
    @Transient
    private transient String unmaskedStringValue;

    public PropertySimple() {
        this.override = Boolean.FALSE;
    }

    public PropertySimple(@NotNull String name, @Nullable Object value) {
        this.setName(name);
        this.setValue(value);
    }

    public void setValue(@Nullable Object value) {
        if (value == null) {
            this.stringValue = null;
            return;
        }
        String sVal = value.toString();
        this.stringValue = sVal.length() > 2000 ? sVal.substring(0, 2000) : sVal;
    }

    @Nullable
    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(@Nullable String value) {
        this.setValue(value);
    }

    @Nullable
    public Boolean getBooleanValue() {
        return this.stringValue == null ? null : Boolean.valueOf(this.stringValue);
    }

    public void setBooleanValue(@Nullable Boolean value) {
        this.setValue(value);
    }

    @Nullable
    public Long getLongValue() {
        return this.stringValue == null ? null : Long.valueOf(this.stringValue);
    }

    public void setLongValue(@Nullable Long value) {
        this.setValue(value);
    }

    @Nullable
    public Integer getIntegerValue() {
        return this.stringValue == null ? null : Integer.valueOf(this.stringValue);
    }

    public void setIntegerValue(@Nullable Integer value) {
        this.setValue(value);
    }

    @Nullable
    public Float getFloatValue() {
        return this.stringValue == null ? null : Float.valueOf(this.stringValue);
    }

    public void setFloatValue(@Nullable Float value) {
        this.setValue(value);
    }

    @Nullable
    public Double getDoubleValue() {
        return this.stringValue == null ? null : Double.valueOf(this.stringValue);
    }

    public void setDoubleValue(@Nullable Double value) {
        this.setValue(value);
    }

    public Boolean getOverride() {
        return this.override;
    }

    public void setOverride(Boolean override) {
        this.override = override;
    }

    public String getUnmaskedStringValue() {
        return this.unmaskedStringValue;
    }

    public void setUnmaskedStringValue(String unmaskedStringValue) {
        this.unmaskedStringValue = unmaskedStringValue;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.stringValue = (String)in.readObject();
        this.override = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.stringValue);
        if (this.override == null) {
            out.writeBoolean(Boolean.FALSE);
        } else {
            out.writeBoolean(this.override);
        }
    }

    public boolean equals(Object obj) {
        String compareToB;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PropertySimple)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PropertySimple that = (PropertySimple)obj;
        String compareToA = this.stringValue != null && this.stringValue.length() == 0 ? null : this.stringValue;
        String string = compareToB = that.stringValue != null && that.stringValue.length() == 0 ? null : that.stringValue;
        return !(compareToA != null ? !compareToA.equals(compareToB) : compareToB != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
        return result;
    }

    protected void appendToStringInternals(StringBuilder str) {
        super.appendToStringInternals(str);
        str.append(", value=").append(this.getStringValue());
        str.append(", override=").append(this.getOverride());
    }
}

