/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.monitor;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;

public class ManageStringThresholdMonitorServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(ManageStringThresholdMonitorServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void error(String msg, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("error", (Object)("Error: " + msg));
        req.getRequestDispatcher("/manageThresholdMonitor.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doit(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ObjectName monitorObjectName;
        String action = req.getParameter("action");
        if (action == null) {
            this.error("unknown action: ", req, resp);
            return;
        }
        String monitorName = req.getParameter("monitorName").trim();
        MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
        ObjectName oname = null;
        String attribute = null;
        try {
            monitorObjectName = new ObjectName(req.getParameter("monitorObjectName"));
        }
        catch (Exception ex) {
            this.error("Malformed Monitor ObjectName: " + req.getParameter("monitorObjectName"), req, resp);
            return;
        }
        if (action.trim().equals("Clear Alert")) {
            try {
                log.debug((Object)("Clearing Alert for monitor: " + monitorObjectName.toString()));
                String[] signature = new String[]{};
                Object[] args = new Object[]{};
                mbeanServer.invoke(monitorObjectName, "clearAlert", args, signature);
                req.setAttribute("error", (Object)"Alert cleared");
                req.getRequestDispatcher("/manageStringThresholdMonitor.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            catch (Exception ex) {
                this.error("Failed to Clear Alert: " + ex.toString(), req, resp);
                return;
            }
        }
        if (action.trim().equals("Remove Monitor")) {
            try {
                log.debug((Object)("removing monitor: " + monitorObjectName.toString()));
                Object[] args = new Object[]{"monitors", monitorName, "-service.xml"};
                String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                mbeanServer.invoke(new ObjectName("jboss.admin:service=DeploymentFileRepository"), "remove", args, signature);
                req.getRequestDispatcher("/ServerInfo.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (Exception ex) {
                this.error("Failed to Remove Monitor: " + ex.toString(), req, resp);
            }
            return;
        }
        try {
            monitorObjectName = new ObjectName(req.getParameter("monitorObjectName"));
            oname = (ObjectName)mbeanServer.getAttribute(monitorObjectName, "ObservedObject");
            attribute = (String)mbeanServer.getAttribute(monitorObjectName, "ObservedAttribute");
        }
        catch (Exception ex) {
            this.error("Malformed Monitor ObjectName: " + req.getParameter("monitorObjectName"), req, resp);
            return;
        }
        String threshold = req.getParameter("threshold").trim();
        log.debug((Object)threshold);
        boolean enabled = req.getParameter("enabled") != null;
        log.debug((Object)("Enabled: " + enabled));
        boolean persisted = req.getParameter("persisted") != null;
        boolean equality = req.getParameter("equality") != null;
        log.debug((Object)("Persisted: " + persisted));
        String period = req.getParameter("period").trim();
        log.debug((Object)period);
        long timePeriod = 0L;
        try {
            timePeriod = Long.parseLong(period);
        }
        catch (NumberFormatException e) {
            this.error("Illegal format for watch period.", req, resp);
            return;
        }
        String[] alerts = req.getParameterValues("alerts");
        if (alerts == null) {
            this.error("you must select at least one alert listener", req, resp);
            return;
        }
        try {
            mbeanServer.setAttribute(monitorObjectName, new Attribute("Threshold", threshold));
            mbeanServer.setAttribute(monitorObjectName, new Attribute("Enabled", new Boolean(enabled)));
            mbeanServer.setAttribute(monitorObjectName, new Attribute("Period", new Long(timePeriod)));
            mbeanServer.setAttribute(monitorObjectName, new Attribute("EqualityTriggersAlert", new Boolean(equality)));
            ArrayList<ObjectName> list = new ArrayList<ObjectName>();
            for (int i = 0; i < alerts.length; ++i) {
                list.add(new ObjectName(alerts[i]));
            }
            mbeanServer.setAttribute(monitorObjectName, new Attribute("AlertListeners", list));
        }
        catch (Exception ex) {
            this.error("Failed to update mbean monitor: " + ex.toString(), req, resp);
            return;
        }
        if (persisted) {
            try {
                Object[] args = new Object[]{"monitors", monitorName, "-service.xml"};
                String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                Object rtn = mbeanServer.invoke(new ObjectName("jboss.admin:service=DeploymentFileRepository"), "isStored", args, signature);
                if (!((Boolean)rtn).booleanValue()) {
                    this.error("Monitor with this name doesn't exist in repository", req, resp);
                    return;
                }
            }
            catch (Exception ex) {
                this.error("Failed to determine if monitor with that name already exists: " + ex.toString(), req, resp);
                return;
            }
            StringBuffer xml = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            xml.append("<server>\n");
            xml.append("<mbean code=\"org.jboss.monitor.StringThresholdMonitor\"\n");
            xml.append("       name=\"jboss.monitor:service=" + monitorName.replace(' ', '_') + "\">\n");
            xml.append("  <attribute name=\"MonitorName\">" + monitorName + "</attribute>\n");
            try {
                if (mbeanServer.isInstanceOf(oname, "org.jboss.system.ServiceMBean")) {
                    xml.append("  <depends optional-attribute-name=\"ObservedObject\">" + oname + "</depends>\n");
                } else {
                    xml.append("  <attribute name=\"ObservedObject\">" + oname + "</attribute>\n");
                }
            }
            catch (Exception ex) {
                this.error("failed creating service: " + ex.toString(), req, resp);
                return;
            }
            xml.append("  <attribute name=\"ObservedAttribute\">" + attribute + "</attribute>\n");
            xml.append("  <depends-list optional-attribute-name=\"AlertListeners\">\n");
            for (int i = 0; i < alerts.length; ++i) {
                xml.append("      <depends-list-element>");
                xml.append(alerts[i].trim());
                xml.append("      </depends-list-element>\n");
            }
            xml.append("  </depends-list>\n");
            xml.append("  <attribute name=\"Threshold\">" + threshold + "</attribute>\n");
            xml.append("  <attribute name=\"Period\">" + timePeriod + "</attribute>\n");
            xml.append("  <attribute name=\"EqualityTriggersAlert\">" + equality + "</attribute>\n");
            xml.append("  <attribute name=\"Enabled\">" + enabled + "</attribute>\n");
            xml.append("</mbean>\n</server>");
            try {
                Object[] args = new Object[]{"monitors", monitorName, "-service.xml", xml.toString(), Boolean.TRUE};
                String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "boolean"};
                mbeanServer.invoke(new ObjectName("jboss.admin:service=DeploymentFileRepository"), "store", args, signature);
            }
            catch (Exception ex) {
                this.error("Failed to create persisted file: " + ex.toString(), req, resp);
                return;
            }
        }
        req.setAttribute("error", (Object)"Update complete!");
        req.getRequestDispatcher("/manageThresholdMonitor.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

