/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.ajax4jsf.util.InputUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIInplaceSelect;
import org.richfaces.renderkit.ComboBoxBaseRenderer;
import org.richfaces.renderkit.ScriptOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InplaceSelectBaseRenderer
extends ComboBoxBaseRenderer {
    private static Log logger = LogFactory.getLog(InplaceSelectBaseRenderer.class);
    private static final String RICH_INPLACE_SELECT_CLASSES = "rich-inplace-select-item rich-inplace-select-font";
    private static final String CONTROLS_FACET = "controls";
    private static final String EMPTY_DEFAULT_LABEL = "\u00a0\u00a0\u00a0";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        UIInplaceSelect inplaceSelect = null;
        if (!(component instanceof UIInplaceSelect)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInplaceSelect"));
            }
            return;
        }
        inplaceSelect = (UIInplaceSelect)component;
        String clientId = inplaceSelect.getClientId(context);
        if (clientId == null) {
            throw new NullPointerException("component client id is NULL");
        }
        if (InputUtils.isDisabled((UIComponent)inplaceSelect) || InputUtils.isReadOnly((UIComponent)inplaceSelect)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
            }
            return;
        }
        Map request = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)request.get(clientId);
        if (newValue != null && newValue.length() != 0) {
            inplaceSelect.setSubmittedValue(newValue);
        } else {
            inplaceSelect.setSubmittedValue(null);
        }
    }

    @Override
    public List<Object> encodeItems(FacesContext context, UIComponent component) throws IOException, IllegalArgumentException {
        if (!this.isAcceptableComponent(component)) {
            return null;
        }
        ArrayList<Object> parentList = new ArrayList<Object>();
        ArrayList<String> labels = new ArrayList<String>();
        UIInplaceSelect inplaceSelect = (UIInplaceSelect)component;
        List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)inplaceSelect);
        for (SelectItem selectItem : selectItems) {
            String value = this.getConvertedStringValue(context, (UIComponent)inplaceSelect, selectItem.getValue());
            String label = selectItem.getLabel().trim();
            labels.add(label);
            this.encodeSuggestion(context, (UIComponent)inplaceSelect, label, RICH_INPLACE_SELECT_CLASSES);
            Object[] child = new Object[]{label, value};
            parentList.add(child);
        }
        return parentList;
    }

    public String encodeScriptAttributes(FacesContext context, UIComponent component) {
        StringBuilder attributes = new StringBuilder();
        attributes.append("var attributes = ");
        ScriptOptions options = new ScriptOptions(component);
        String defaultLabel = (String)component.getAttributes().get("defaultLabel");
        if (defaultLabel == null || defaultLabel.trim().equals("")) {
            defaultLabel = EMPTY_DEFAULT_LABEL;
        }
        options.addOption("defaultLabel", (Object)defaultLabel);
        options.addOption("showControls");
        options.addOption("editEvent");
        options.addOption("verticalPosition", component.getAttributes().get("controlsVerticalPosition"));
        options.addOption("horizontalPosition", component.getAttributes().get("controlsHorizontalPosition"));
        options.addOption("inputWidth", component.getAttributes().get("selectWidth"));
        options.addOption("minInputWidth", component.getAttributes().get("minSelectWidth"));
        options.addOption("maxInputWidth", component.getAttributes().get("maxSelectWidth"));
        options.addOption("openOnEdit");
        options.addOption("showValueInView");
        options.addOption("closeOnSelect", (Object)true);
        attributes.append(options.toScript());
        return attributes.toString();
    }

    public void encodeControlsFacet(FacesContext context, UIComponent component) throws IOException {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        if (facet != null && facet.isRendered()) {
            this.renderChild(context, facet);
        }
    }

    public boolean isControlsFacetExists(FacesContext context, UIComponent component) {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        return facet != null && facet.isRendered();
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIInplaceSelect.class;
    }

    protected String getItemLabel(FacesContext context, UIInplaceSelect component, Object value) {
        List selectItems;
        String itemLabel = null;
        if (value != null && !(selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component)).isEmpty()) {
            for (SelectItem item : selectItems) {
                if (!value.equals(item.getValue())) continue;
                itemLabel = component.isShowValueInView() ? this.getConvertedStringValue(context, (UIComponent)component, item.getValue()) : item.getLabel();
                break;
            }
        }
        return itemLabel;
    }

    protected String createDefaultLabel(UIComponent component) {
        String defaultLabel = (String)component.getAttributes().get("defaultLabel");
        if (defaultLabel == null || defaultLabel.trim().equals("")) {
            defaultLabel = EMPTY_DEFAULT_LABEL;
        }
        return defaultLabel;
    }

    protected boolean isEmptyDefaultLabel(String defaultLabel) {
        return EMPTY_DEFAULT_LABEL.equals(defaultLabel);
    }
}

