/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.soap.DetailImpl;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPFactoryImpl
extends SOAPFactory {
    private static Logger log = Logger.getLogger(SOAPFactoryImpl.class);
    private String envNamespace;

    public SOAPFactoryImpl() {
        this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    }

    public SOAPFactoryImpl(String protocol) throws SOAPException {
        if ("SOAP 1.2 Protocol".equals(protocol)) {
            this.envNamespace = "http://www.w3.org/2003/05/soap-envelope";
        } else if ("SOAP 1.1 Protocol".equals(protocol)) {
            this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
        } else if ("Dynamic Protocol".equals(protocol)) {
            this.envNamespace = null;
        } else {
            throw new SOAPException("Unknown protocol: " + protocol);
        }
    }

    public SOAPElement createElement(Name name) throws SOAPException {
        return new SOAPElementImpl(name);
    }

    public SOAPElement createElement(QName qname) throws SOAPException {
        return this.createElement(new NameImpl(qname));
    }

    public SOAPElement createElement(String localName) throws SOAPException {
        return new SOAPElementImpl(localName);
    }

    public SOAPElement createElement(String localName, String prefix, String uri) throws SOAPException {
        return new SOAPElementImpl(localName, prefix, uri);
    }

    public SOAPElement createElement(Element domElement) throws SOAPException {
        return this.createElement(domElement, true);
    }

    public SOAPElement createElement(Element domElement, boolean deep) throws SOAPException {
        if (domElement == null) {
            throw new IllegalArgumentException("Source node cannot be null");
        }
        if (domElement instanceof SOAPElement && deep) {
            return (SOAPElement)domElement;
        }
        String localName = domElement.getLocalName();
        String prefix = domElement.getPrefix() != null ? domElement.getPrefix() : "";
        String nsURI = domElement.getNamespaceURI() != null ? domElement.getNamespaceURI() : "";
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement soapElement = factory.createElement(localName, prefix, nsURI);
        DOMUtils.copyAttributes((Element)soapElement, (Element)domElement);
        if (deep) {
            NodeList nlist = domElement.getChildNodes();
            for (int i = 0; i < nlist.getLength(); ++i) {
                String nodeValue;
                Node child = nlist.item(i);
                short nodeType = child.getNodeType();
                if (nodeType == 1) {
                    SOAPElement soapChild = this.createElement((Element)child);
                    soapElement.addChildElement(soapChild);
                    if (!Constants.NAME_XOP_INCLUDE.equals(soapChild.getElementQName())) continue;
                    XOPContext.inlineXOPData(soapChild);
                    continue;
                }
                if (nodeType == 3) {
                    nodeValue = child.getNodeValue();
                    soapElement.addTextNode(nodeValue);
                    continue;
                }
                if (nodeType == 4) {
                    nodeValue = child.getNodeValue();
                    soapElement.addTextNode(nodeValue);
                    continue;
                }
                log.trace((Object)("Ignore child type: " + nodeType));
            }
        }
        return soapElement;
    }

    public Detail createDetail() throws SOAPException {
        this.assertEnvNamespace();
        return "http://schemas.xmlsoap.org/soap/envelope/".equals(this.envNamespace) ? new DetailImpl() : new DetailImpl("env", this.envNamespace);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(localName, prefix, uri);
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }

    public SOAPFault createFault(String reasonText, QName faultCode) throws SOAPException {
        this.assertEnvNamespace();
        SOAPFaultImpl soapFault = new SOAPFaultImpl("env", this.envNamespace);
        soapFault.setFaultCode(faultCode);
        soapFault.setFaultString(reasonText);
        return soapFault;
    }

    public SOAPFault createFault() throws SOAPException {
        this.assertEnvNamespace();
        SOAPFaultImpl soapFault = new SOAPFaultImpl("env", this.envNamespace);
        soapFault.setFaultCode(soapFault.getDefaultFaultCode());
        return soapFault;
    }

    private void assertEnvNamespace() {
        if (this.envNamespace == null) {
            throw new UnsupportedOperationException("Envelope namespace not specified, use one of the SOAP protocols");
        }
    }
}

