/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.Collections;
import java.util.List;
import org.gatein.common.util.MarkupInfo;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.RuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestPrecursor {
    private static final Logger log = LoggerFactory.getLogger(RequestPrecursor.class);
    private org.oasis.wsrp.v1.PortletContext portletContext;
    RuntimeContext runtimeContext;
    MarkupParams markupParams;
    private static final String PORTLET_HANDLE = "portlet handle";
    private static final String SECURITY_CONTEXT = "security context";
    private static final String USER_CONTEXT = "user context";
    private static final String INVOCATION_CONTEXT = "invocation context";
    private static final String STREAM_INFO = "stream info in invocation context";
    private static final String USER_AGENT = "User-Agent";

    public RequestPrecursor(WSRPConsumerImpl wsrpConsumer, PortletInvocation invocation) throws PortletInvokerException {
        String state;
        String windowState;
        String mode;
        this.portletContext = WSRPUtils.convertToWSRPPortletContext((PortletContext)WSRPConsumerImpl.getPortletContext(invocation));
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)this.getPortletHandle(), (String)PORTLET_HANDLE, null);
        if (log.isDebugEnabled()) {
            log.debug("About to invoke on portlet: " + this.getPortletHandle());
        }
        SecurityContext securityContext = invocation.getSecurityContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)securityContext, (String)SECURITY_CONTEXT);
        String authType = WSRPUtils.convertRequestAuthTypeToWSRPAuthType((String)securityContext.getAuthType());
        this.runtimeContext = WSRPTypeFactory.createRuntimeContext((String)authType);
        wsrpConsumer.getSessionHandler().setSessionIdIfNeeded(invocation, this.runtimeContext, this.getPortletHandle());
        wsrpConsumer.setTemplatesIfNeeded(invocation, this.runtimeContext);
        UserContext userContext = invocation.getUserContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)userContext, (String)USER_CONTEXT);
        PortletInvocationContext context = invocation.getContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)context, (String)INVOCATION_CONTEXT);
        MarkupInfo streamInfo = context.getMarkupInfo();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)streamInfo, (String)STREAM_INFO);
        try {
            mode = WSRPUtils.getWSRPNameFromJSR168PortletMode((Mode)invocation.getMode());
        }
        catch (Exception e) {
            log.debug("Mode was null in context.");
            mode = "wsrp:view";
        }
        try {
            windowState = WSRPUtils.getWSRPNameFromJSR168WindowState((WindowState)invocation.getWindowState());
        }
        catch (Exception e) {
            log.debug("WindowState was null in context.");
            windowState = "wsrp:normal";
        }
        this.markupParams = WSRPTypeFactory.createMarkupParams((boolean)securityContext.isSecure(), (List)WSRPUtils.convertLocalesToRFC3066LanguageTags((List)userContext.getLocales()), Collections.singletonList(streamInfo.getMediaType().getValue()), (String)mode, (String)windowState);
        String userAgent = WSRPConsumerImpl.getHttpRequest(invocation).getHeader(USER_AGENT);
        this.markupParams.setClientData(WSRPTypeFactory.createClientData((String)userAgent));
        StateString navigationalState = invocation.getNavigationalState();
        if (navigationalState != null && !"JBPNS_".equals(state = navigationalState.getStringValue())) {
            this.markupParams.setNavigationalState(state);
        }
        if (log.isDebugEnabled()) {
            log.debug(WSRPUtils.toString((MarkupParams)this.markupParams));
        }
    }

    public String getPortletHandle() {
        return this.portletContext.getPortletHandle();
    }

    public org.oasis.wsrp.v1.PortletContext getPortletContext() {
        return this.portletContext;
    }
}

