/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.ContentServiceRequest;
import org.rhq.core.domain.content.InstalledPackageHistoryStatus;
import org.rhq.core.domain.content.PackageInstallationStep;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="InstalledPackageHistory.findConfigByPackageVersionAndReq", query="SELECT dcv FROM InstalledPackageHistory iph JOIN iph.deploymentConfigurationValues dcv WHERE iph.packageVersion = :packageVersion AND iph.contentServiceRequest = :contentServiceRequest ORDER BY iph.timestamp DESC"), @NamedQuery(name="InstalledPackageHistory.findByCsrIdAndPkgVerId", query="SELECT iph FROM InstalledPackageHistory iph WHERE iph.contentServiceRequest.id = :contentServiceRequestId AND iph.packageVersion.id = :packageVersionId ORDER BY timestamp DESC"), @NamedQuery(name="InstalledPackageHistory.findByCsrId", query="SELECT iph FROM InstalledPackageHistory iph WHERE iph.contentServiceRequest.id = :contentServiceRequestId"), @NamedQuery(name="InstalledPackageHistory.findByResourceIdAndPkgId", query="SELECT iph FROM InstalledPackageHistory iph WHERE iph.packageVersion.generalPackage.id = :packageId AND iph.resource.id = :resourceId"), @NamedQuery(name="InstalledPackageHistory.findByResourceId", query="SELECT iph FROM InstalledPackageHistory iph WHERE iph.resource.id = :resourceId"), @NamedQuery(name="InstalledPackageHistory.findById", query="SELECT iph FROM InstalledPackageHistory iph WHERE iph.id = :id"), @NamedQuery(name="InstalledPackageHistory.deleteByResources", query="DELETE FROM InstalledPackageHistory iph  WHERE iph.resource IN (:resources))")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_INSTALLED_PKG_HIST_ID_SEQ")
@Table(name="RHQ_INSTALLED_PKG_HIST")
public class InstalledPackageHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_CONFIG_BY_PACKAGE_VERSION_AND_REQ = "InstalledPackageHistory.findConfigByPackageVersionAndReq";
    public static final String QUERY_FIND_BY_CSR_ID_AND_PKG_VER_ID = "InstalledPackageHistory.findByCsrIdAndPkgVerId";
    public static final String QUERY_FIND_BY_CSR_ID = "InstalledPackageHistory.findByCsrId";
    public static final String QUERY_FIND_BY_RESOURCE_ID_AND_PKG_ID = "InstalledPackageHistory.findByResourceIdAndPkgId";
    public static final String QUERY_FIND_BY_RESOURCE_ID = "InstalledPackageHistory.findByResourceId";
    public static final String QUERY_FIND_BY_ID = "InstalledPackageHistory.findById";
    public static final String QUERY_DELETE_BY_RESOURCES = "InstalledPackageHistory.deleteByResources";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="PACKAGE_VERSION_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private PackageVersion packageVersion;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private InstalledPackageHistoryStatus status;
    @Column(name="ERROR_MESSAGE", nullable=true)
    private String errorMessage;
    @Column(name="HISTORY_TIMESTAMP", nullable=true)
    private Long timestamp;
    @JoinColumn(name="DEPLOYMENT_CONFIG_ID", referencedColumnName="ID", nullable=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Configuration deploymentConfigurationValues;
    @OneToMany(mappedBy="installedPackageHistory", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<PackageInstallationStep> installationSteps;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private Resource resource;
    @JoinColumn(name="CONTENT_SERVICE_REQUEST_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    private ContentServiceRequest contentServiceRequest;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(PackageVersion packageVersion) {
        this.packageVersion = packageVersion;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public InstalledPackageHistoryStatus getStatus() {
        return this.status;
    }

    public void setStatus(InstalledPackageHistoryStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public Configuration getDeploymentConfigurationValues() {
        return this.deploymentConfigurationValues;
    }

    public void setDeploymentConfigurationValues(Configuration deploymentConfigurationValues) {
        this.deploymentConfigurationValues = deploymentConfigurationValues;
    }

    public List<PackageInstallationStep> getInstallationSteps() {
        return this.installationSteps;
    }

    public void setInstallationSteps(List<PackageInstallationStep> installationSteps) {
        this.installationSteps = installationSteps;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public ContentServiceRequest getContentServiceRequest() {
        return this.contentServiceRequest;
    }

    public void setContentServiceRequest(ContentServiceRequest contentServiceRequest) {
        this.contentServiceRequest = contentServiceRequest;
    }
}

