/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.taxonomy;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyTreeData
implements Comparable<TaxonomyTreeData> {
    private String taxoTreeName;
    private String repository;
    private String taxoTreeWorkspace;
    private String taxoTreePermissions;
    private String taxoTreeHomePath;
    private String taxoTreeActionName;
    private String taxoTreeActionTargetPath;
    private String taxoTreeActionTargetWorkspace;
    private String taxoTreeActionTypeName;
    private boolean edit = false;
    public static final String ACTION_TAXONOMY_TREE = "exo:taxonomyAction";

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String rp) {
        this.repository = rp;
    }

    public String getPermissions() {
        return this.taxoTreePermissions;
    }

    public boolean hasPermission(String[] allPermissions, String permission) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String per : allPermissions) {
            permissionList.add(per.trim());
        }
        if (permission == null) {
            return false;
        }
        if (permission.indexOf(":/") > -1) {
            String[] array = permission.split(":/");
            if (array == null || array.length < 2) {
                return false;
            }
            if (permissionList.contains("*:/" + array[1])) {
                return true;
            }
        }
        return permissionList.contains(permission);
    }

    @Override
    public int compareTo(TaxonomyTreeData arg) {
        return this.taxoTreeName.compareToIgnoreCase(arg.getTaxoTreeName());
    }

    public String getTaxoTreeHomePath() {
        return this.taxoTreeHomePath;
    }

    public void setTaxoTreeHomePath(String taxoTreeHomePath) {
        this.taxoTreeHomePath = taxoTreeHomePath;
    }

    public String getTaxoTreeName() {
        return this.taxoTreeName;
    }

    public void setTaxoTreeName(String taxoTreeName) {
        this.taxoTreeName = taxoTreeName;
    }

    public String getTaxoTreePermissions() {
        return this.taxoTreePermissions;
    }

    public void setTaxoTreePermissions(String permission) {
        this.taxoTreePermissions = permission;
    }

    public String getTaxoTreeWorkspace() {
        return this.taxoTreeWorkspace;
    }

    public void setTaxoTreeWorkspace(String taxoTreeWorkspace) {
        this.taxoTreeWorkspace = taxoTreeWorkspace;
    }

    public String getTaxoTreeActionName() {
        return this.taxoTreeActionName;
    }

    public void setTaxoTreeActionName(String taxoTreeActionName) {
        this.taxoTreeActionName = taxoTreeActionName;
    }

    public String getTaxoTreeActionTypeName() {
        return this.taxoTreeActionTypeName;
    }

    public void setTaxoTreeActionTypeName(String taxoTreeActionTypeName) {
        this.taxoTreeActionTypeName = taxoTreeActionTypeName;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }
}

