/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.Application;
import org.exoplatform.webui.application.portlet.PortletApplication;

public class PortletApplicationController
extends GenericPortlet {
    protected static Log log = ExoLogger.getLogger(PortletApplicationController.class);
    private String applicationId_;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext pcontext = config.getPortletContext();
        String contextName = pcontext.getPortletContextName();
        this.applicationId_ = contextName + "/" + config.getPortletName();
    }

    public void processAction(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        try {
            this.getPortletApplication().processAction(req, res);
        }
        catch (Exception ex) {
            log.error((Object)"Error while processing action in the porlet", (Throwable)ex);
        }
    }

    public void processEvent(EventRequest req, EventResponse res) {
        try {
            this.getPortletApplication().processEvent(req, res);
        }
        catch (Exception ex) {
            log.error((Object)"Error while processing event in the porlet", (Throwable)ex);
        }
    }

    public void render(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        try {
            this.getPortletApplication().render(req, res);
        }
        catch (Exception ex) {
            log.error((Object)"Error while rendering the porlet", (Throwable)ex);
        }
    }

    private PortletApplication getPortletApplication() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
        PortletApplication application = (PortletApplication)controller.getApplication(this.applicationId_);
        if (application == null) {
            application = new PortletApplication(this.getPortletConfig());
            application.onInit();
            application = (PortletApplication)controller.addApplication((Application)application);
        }
        return application;
    }

    public void destroy() {
        ExoContainer rootContainer = ExoContainerContext.getTopContainer();
        List containers = rootContainer.getComponentInstancesOfType(ExoContainer.class);
        containers.add(rootContainer);
        try {
            for (ExoContainer container : containers) {
                PortletApplication application;
                ExoContainerContext.setCurrentContainer((ExoContainer)container);
                WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
                if (controller == null || (application = (PortletApplication)controller.getApplication(this.applicationId_)) == null) continue;
                application.onDestroy();
                controller.removeApplication(this.applicationId_);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error while destroying the porlet", (Throwable)ex);
        }
    }
}

