/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RSACoreEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.core.init(bl, cipherParameters);
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.key = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            this.key = (RSAKeyParameters)cipherParameters;
            this.random = new SecureRandom();
        }
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) {
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)this.key;
            if (rSAPrivateCrtKeyParameters.getPublicExponent() != null) {
                BigInteger bigInteger = this.core.convertInput(byArray, n, n2);
                BigInteger bigInteger2 = rSAPrivateCrtKeyParameters.getModulus();
                BigInteger bigInteger3 = this.calculateR(bigInteger2);
                BigInteger bigInteger4 = this.core.processBlock(bigInteger3.modPow(rSAPrivateCrtKeyParameters.getPublicExponent(), bigInteger2).multiply(bigInteger).mod(bigInteger2));
                return this.core.convertOutput(bigInteger4.multiply(bigInteger3.modInverse(bigInteger2)).mod(bigInteger2));
            }
            return this.core.convertOutput(this.core.processBlock(this.core.convertInput(byArray, n, n2)));
        }
        return this.core.convertOutput(this.core.processBlock(this.core.convertInput(byArray, n, n2)));
    }

    private BigInteger calculateR(BigInteger bigInteger) {
        int n = bigInteger.bitLength() - 1;
        int n2 = n / 2;
        int n3 = (this.random.nextInt() & 0xFF) * ((n - n2) / 255) + n2;
        BigInteger bigInteger2 = new BigInteger(n3, this.random);
        while (bigInteger2.equals(ZERO)) {
            bigInteger2 = new BigInteger(n3, this.random);
        }
        return bigInteger2;
    }
}

