/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NodetypeUtils {
    private static final Log LOG = ExoLogger.getLogger(NodetypeUtils.class);

    public static void displayAllNode(String workspaceName, String repositoryName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository repository = repositoryService.getRepository(repositoryName);
        Session session = sessionProvider.getSession(workspaceName, repository);
        Node root = session.getRootNode();
        NodetypeUtils.displayAllChildNode(root);
    }

    public static void displayAllChildNode(Node node) throws Exception {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node childNode = nodeIterator.nextNode();
            NodetypeUtils.displayOneNode(childNode);
            LOG.info((Object)"\n------------------\n");
            NodetypeUtils.displayAllChildNode(childNode);
        }
    }

    public static void displayOneNode(Node node) throws Exception {
        LOG.info((Object)("Node name: " + node.getName()));
        LOG.info((Object)("Node path: " + node.getPath()));
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            try {
                LOG.info((Object)("\t" + property.getName() + ": " + property.getString()));
            }
            catch (Exception e) {
                for (Value value : property.getValues()) {
                    LOG.info((Object)("\t" + property.getName() + ": " + value.getString()));
                }
            }
        }
    }
}

