/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitorListener;
import org.exoplatform.services.jcr.jbosscache.PrivilegedJBossCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.event.NodeModifiedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class JBossCacheIndexUpdateMonitor
implements IndexUpdateMonitor,
IndexerIoModeListener {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.JBossCacheIndexUpdateMonitor");
    private final Cache<Serializable, Object> cache;
    private boolean localUpdateInProgress = false;
    private static final String INDEX_PARAMETERS = "$index_parameters".intern();
    private static final String SYSINDEX_PARAMETERS = "$sysindex_parameters".intern();
    private static final String PARAMETER_NAME = "index-update-in-progress";
    public final IndexerIoModeHandler modeHandler;
    private final List<IndexUpdateMonitorListener> listeners;
    private final Fqn parametersFqn;

    public JBossCacheIndexUpdateMonitor(Fqn<String> rootFqn, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        this.cache = cache;
        this.modeHandler = modeHandler;
        this.listeners = new CopyOnWriteArrayList<IndexUpdateMonitorListener>();
        this.parametersFqn = Fqn.fromRelativeElements(rootFqn, (Object[])new String[]{system ? INDEX_PARAMETERS : SYSINDEX_PARAMETERS});
        modeHandler.addIndexerIoModeListener(this);
        Node cacheRoot = cache.getRoot();
        if (!cacheRoot.hasChild(this.parametersFqn)) {
            cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            cacheRoot.addChild(this.parametersFqn).setResident(true);
        } else {
            cache.getNode(this.parametersFqn).setResident(true);
        }
        if (IndexerIoMode.READ_WRITE == modeHandler.getMode()) {
            this.setUpdateInProgress(false, true);
        } else {
            cache.addCacheListener((Object)this);
            Object value = cache.get(this.parametersFqn, (Object)PARAMETER_NAME);
            this.localUpdateInProgress = value != null ? (Boolean)value : false;
        }
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        if (mode == IndexerIoMode.READ_WRITE) {
            this.cache.removeCacheListener((Object)this);
        } else {
            this.cache.addCacheListener((Object)this);
        }
    }

    @Override
    public boolean getUpdateInProgress() {
        return this.localUpdateInProgress;
    }

    @Override
    public void setUpdateInProgress(boolean updateInProgress, boolean persitentUpdate) {
        if (IndexerIoMode.READ_ONLY == this.modeHandler.getMode()) {
            throw new IllegalStateException("Unable to set updateInProgress value in IndexerIoMode.READ_ONLY mode");
        }
        try {
            this.localUpdateInProgress = updateInProgress;
            if (persitentUpdate) {
                PrivilegedJBossCacheHelper.put(this.cache, this.parametersFqn, (Serializable)((Object)PARAMETER_NAME), (Object)new Boolean(updateInProgress));
            }
            for (IndexUpdateMonitorListener listener : this.listeners) {
                listener.onUpdateInProgressChange(updateInProgress);
            }
        }
        catch (CacheException e) {
            this.log.error((Object)("Fail to change updateInProgress mode to " + updateInProgress), (Throwable)e);
        }
    }

    @Override
    public void addIndexUpdateMonitorListener(IndexUpdateMonitorListener listener) {
        this.listeners.add(listener);
    }

    @NodeModified
    public void cacheNodeModified(NodeModifiedEvent event) {
        if (!event.isPre() && event.getFqn().equals((Object)this.parametersFqn)) {
            Object value = null;
            Map data = event.getData();
            if (data == null) {
                this.log.warn((Object)"The data map is empty");
            } else {
                value = data.get(PARAMETER_NAME);
            }
            if (value == null) {
                this.log.warn((Object)"The data cannot be found, we will try to get it from the cache");
                value = this.cache.get(this.parametersFqn, (Object)PARAMETER_NAME);
            }
            this.localUpdateInProgress = value != null ? (Boolean)value : false;
            for (IndexUpdateMonitorListener listener : this.listeners) {
                listener.onUpdateInProgressChange(this.localUpdateInProgress);
            }
        }
    }
}

