/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan;

import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.CacheKey;

class CacheQPath
extends CacheKey {
    private final String parentId;
    private final QPath path;

    CacheQPath(String parentId, QPath path, ItemType itemType) {
        super((parentId != null ? parentId : Constants.ROOT_PARENT_UUID) + path.getEntries()[path.getEntries().length - 1].getAsString(true) + itemType.toString());
        this.parentId = parentId;
        this.path = path;
    }

    CacheQPath(String parentId, QPathEntry name, ItemType itemType) {
        super((parentId != null ? parentId : Constants.ROOT_PARENT_UUID) + name.getAsString(true) + itemType.toString());
        this.parentId = parentId;
        this.path = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CacheQPath) {
            CacheQPath cacheQPath = (CacheQPath)obj;
            return cacheQPath.hashCode() == this.hash && cacheQPath.id.equals(this.id);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.parentId != null ? this.parentId : Constants.ROOT_PARENT_UUID);
        s.append(this.path != null ? this.path.getEntries()[this.path.getEntries().length - 1] : "null");
        s.append(", ");
        s.append(this.id);
        return s.toString();
    }
}

