/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.FieldInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.core.AbstractTypeInfo;
import org.reflext.core.AnnotatedDelegate;
import org.reflext.core.FieldInfoImpl;
import org.reflext.core.MethodInfoImpl;
import org.reflext.core.TypeResolverImpl;
import org.reflext.core.TypeVariableInfoImpl;
import org.reflext.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassTypeInfoImpl<T, M, A, P, F>
extends AbstractTypeInfo<T, M, A, P, F>
implements ClassTypeInfo {
    private final T classType;
    private final String className;
    private List<TypeInfo> interfaces;
    private TypeInfo superType;
    private boolean superClassResolved;
    private List<TypeVariableInfo> typeParameters;
    private List<MethodInfo> methods;
    private LinkedHashMap<String, FieldInfo> fields;
    private final String simpleName;
    private final String packageName;
    private final ClassKind kind;
    private ClassTypeInfo enclosing;
    private boolean enclosingResolved;
    private AnnotatedDelegate<T, M, A, P, F, T> annotatedDelegate;

    public ClassTypeInfoImpl(TypeResolverImpl<T, M, A, P, F> domain, T classType) {
        super(domain);
        String packageName;
        String simpleName;
        String className = domain.typeModel.getClassName(classType);
        int index = className.lastIndexOf(46);
        if (index == -1) {
            simpleName = className;
            packageName = "";
        } else {
            simpleName = className.substring(index + 1);
            packageName = className.substring(0, index);
        }
        ClassKind kind = domain.typeModel.getClassKind(classType);
        this.className = className;
        this.classType = classType;
        this.interfaces = null;
        this.superType = null;
        this.superClassResolved = false;
        this.simpleName = simpleName;
        this.packageName = packageName;
        this.kind = kind;
        this.annotatedDelegate = null;
        this.methods = null;
        this.fields = null;
        this.enclosing = null;
        this.enclosingResolved = false;
    }

    public String getName() {
        return this.className;
    }

    public boolean isReified() {
        return true;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassTypeInfo getEnclosing() {
        if (!this.enclosingResolved) {
            Object enclosingType = this.domain.typeModel.getEnclosing(this.classType);
            if (enclosingType != null) {
                this.enclosing = (ClassTypeInfo)this.domain.resolve(enclosingType);
            }
            this.enclosingResolved = true;
        }
        return this.enclosing;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public ClassKind getKind() {
        return this.kind;
    }

    public List<TypeVariableInfo> getTypeParameters() {
        if (this.typeParameters == null) {
            ArrayList<TypeVariableInfo> typeParameters = new ArrayList<TypeVariableInfo>();
            for (Object tv : this.domain.typeModel.getTypeParameters(this.classType)) {
                TypeVariableInfoImpl typeParameter = (TypeVariableInfoImpl)this.domain._getType(tv);
                typeParameters.add(typeParameter);
            }
            this.typeParameters = typeParameters;
        }
        return this.typeParameters;
    }

    public Iterable<TypeInfo> getInterfaces() {
        if (this.interfaces == null) {
            ArrayList<TypeInfo> interfaces = new ArrayList<TypeInfo>();
            for (Object interfaceType : this.domain.typeModel.getInterfaces(this.classType)) {
                TypeInfo itf = this.domain.resolve(interfaceType);
                interfaces.add(itf);
            }
            this.interfaces = interfaces;
        }
        return this.interfaces;
    }

    public TypeInfo getSuperType() {
        if (!this.superClassResolved) {
            Object superClassType = this.domain.typeModel.getSuperClass(this.classType);
            if (superClassType != null) {
                this.superType = this.domain.resolve(superClassType);
            }
            this.superClassResolved = true;
        }
        return this.superType;
    }

    public TypeInfo resolve(TypeInfo type) {
        return Utils.resolve((ClassTypeInfo)this, type);
    }

    public List<MethodInfo> getDeclaredMethods() {
        if (this.methods == null) {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            for (Object method : this.domain.methodModel.getDeclaredMethods(this.classType)) {
                MethodInfoImpl mi = new MethodInfoImpl(this, this.domain, method);
                methods.add(mi);
            }
            this.methods = methods;
        }
        return this.methods;
    }

    public MethodInfo getDeclaredMethod(MethodSignature methodSignature) {
        for (MethodInfo methodInfo : this.getDeclaredMethods()) {
            if (!methodInfo.getSignature().equals((Object)methodSignature)) continue;
            return methodInfo;
        }
        return null;
    }

    private Map<String, FieldInfo> getDeclaredFieldMap() {
        if (this.fields == null) {
            LinkedHashMap fields = new LinkedHashMap();
            for (Object field : this.domain.fieldModel.getDeclaredFields(this.classType)) {
                FieldInfoImpl fi = new FieldInfoImpl(this, this.domain, field);
                fields.put(fi.getName(), fi);
            }
            this.fields = fields;
        }
        return this.fields;
    }

    public Collection<FieldInfo> getDeclaredFields() {
        return this.getDeclaredFieldMap().values();
    }

    public FieldInfo getDeclaredField(String fieldName) {
        return this.getDeclaredFieldMap().get(fieldName);
    }

    public ClassTypeInfo getSuperClass() {
        TypeInfo superType = this.getSuperType();
        if (superType == null) {
            return null;
        }
        if (superType instanceof ClassTypeInfo) {
            return (ClassTypeInfo)superType;
        }
        if (superType instanceof ParameterizedTypeInfo) {
            TypeInfo rawType = ((ParameterizedTypeInfo)superType).getRawType();
            if (rawType instanceof ClassTypeInfo) {
                return (ClassTypeInfo)rawType;
            }
            throw new AssertionError((Object)("Cannot cast raw type " + rawType + " to class type"));
        }
        throw new AssertionError((Object)("Cannot cast type " + superType + " to class type"));
    }

    private boolean isAssignableFrom(TypeInfo that) {
        if (that instanceof ClassTypeInfo) {
            return this.isAssignableFrom((ClassTypeInfo)that);
        }
        if (that instanceof ParameterizedTypeInfo) {
            return this.isAssignableFrom(((ParameterizedTypeInfo)that).getRawType());
        }
        if (that instanceof TypeVariableInfo) {
            return this.isAssignableFrom((TypeInfo)((TypeVariableInfo)that).getBounds().get(0));
        }
        return false;
    }

    public boolean isAssignableFrom(ClassTypeInfo that) {
        if (this.className.equals("java.lang.Object")) {
            return true;
        }
        if (this.className.equals(that.getName())) {
            return true;
        }
        TypeInfo superType = that.getSuperType();
        if (superType != null && this.isAssignableFrom(superType)) {
            return true;
        }
        for (TypeInfo itf : that.getInterfaces()) {
            if (!this.isAssignableFrom(itf)) continue;
            return true;
        }
        return false;
    }

    public T unwrap() {
        return this.classType;
    }

    public <AT> AT getDeclaredAnnotation(AnnotationType<AT, ?> annotationType) {
        if (this.annotatedDelegate == null) {
            this.annotatedDelegate = new AnnotatedDelegate(this.domain, this.domain.typeAnnotationModel, this.classType);
        }
        return this.annotatedDelegate.getDeclaredAnnotation(this.classType, annotationType);
    }

    @Override
    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassTypeInfo) {
            ClassTypeInfo that = (ClassTypeInfo)obj;
            String thatName = that.getName();
            return this.className.equals(thatName);
        }
        return false;
    }

    public String toString() {
        return "ClassTypeInfo[className=" + this.className + "]";
    }
}

