/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;

public class RandomAccessFileInputStream
extends InputStream
implements SeekableInput {
    private static final Logger logger = Logger.getLogger(RandomAccessFileInputStream.class.toString());
    private long m_lMarkPosition = 0L;
    private RandomAccessFile m_RandomAccessFile;
    private Object m_oCurrentUser;

    public static RandomAccessFileInputStream build(File file) throws FileNotFoundException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        RandomAccessFileInputStream rafis = new RandomAccessFileInputStream(raf);
        return rafis;
    }

    protected RandomAccessFileInputStream(RandomAccessFile raf) {
        this.m_RandomAccessFile = raf;
    }

    public int read() throws IOException {
        return this.m_RandomAccessFile.read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.m_RandomAccessFile.read(buffer);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.m_RandomAccessFile.read(buffer, offset, length);
    }

    public void close() throws IOException {
        this.m_RandomAccessFile.close();
    }

    public int available() {
        return 0;
    }

    public void mark(int readLimit) {
        try {
            this.m_lMarkPosition = this.m_RandomAccessFile.getFilePointer();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        this.m_RandomAccessFile.seek(this.m_lMarkPosition);
    }

    public long skip(long n) throws IOException {
        int nn = (int)(n & 0xFFFFFFFFFFFFFFFFL);
        return this.m_RandomAccessFile.skipBytes(nn);
    }

    public void seekAbsolute(long absolutePosition) throws IOException {
        this.m_RandomAccessFile.seek(absolutePosition);
    }

    public void seekRelative(long relativeOffset) throws IOException {
        long pos = this.m_RandomAccessFile.getFilePointer();
        if ((pos += relativeOffset) < 0L) {
            pos = 0L;
        }
        this.m_RandomAccessFile.seek(pos);
    }

    public void seekEnd() throws IOException {
        long end = this.m_RandomAccessFile.length();
        this.seekAbsolute(end);
    }

    public long getAbsolutePosition() throws IOException {
        return this.m_RandomAccessFile.getFilePointer();
    }

    public long getLength() throws IOException {
        return this.m_RandomAccessFile.length();
    }

    public InputStream getInputStream() {
        return this;
    }

    public synchronized void beginThreadAccess() {
        Thread requestingUser = Thread.currentThread();
        while (true) {
            if (this.m_oCurrentUser == null) {
                this.m_oCurrentUser = requestingUser;
                break;
            }
            if (this.m_oCurrentUser == requestingUser) break;
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void endThreadAccess() {
        Thread requestingUser = Thread.currentThread();
        if (this.m_oCurrentUser == null) {
            this.notifyAll();
        } else if (this.m_oCurrentUser == requestingUser) {
            this.m_oCurrentUser = null;
            this.notifyAll();
        } else if (logger.isLoggable(Level.SEVERE)) {
            logger.severe("ERROR:  Thread finished using SeekableInput, but it wasn't locked by that Thread\n        Thread: " + Thread.currentThread() + "\n" + "        Locking Thread: " + this.m_oCurrentUser + "\n" + "        SeekableInput: " + this);
        }
    }
}

