/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.comparator.ItemOptionNameComparator;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.form.validator.IllegalDMSCharValidator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/popup/action/UIAddFolder.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFolderForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_TYPE = "type";
    private String allowCreateFolder_;

    public void activate() throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node currentNode = uiExplorer.getCurrentNode();
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        String foldertypes = uiExplorer.getDriveData().getAllowCreateFolders();
        if (foldertypes.contains(",")) {
            this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_TYPE, FIELD_TYPE, null));
            String[] arrFoldertypes = foldertypes.split(",");
            String label = "";
            NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
            for (String foldertype : arrFoldertypes) {
                if (currentNode.isNodeType("nt:folder") && !ntManager.getNodeType(foldertype).isNodeType("nt:folder")) continue;
                try {
                    label = res.getString(this.getId() + ".label." + foldertype.replace(":", "_"));
                }
                catch (MissingResourceException e) {
                    label = foldertype;
                }
                options.add(new SelectItemOption(label, (Object)foldertype));
            }
            Collections.sort(options, new ItemOptionNameComparator());
            this.getUIFormSelectBox(FIELD_TYPE).setOptions(options);
        } else {
            this.allowCreateFolder_ = foldertypes;
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_TITLE, FIELD_TITLE, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(IllegalDMSCharValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(IllegalDMSCharValidator.class, new Object[0]));
        this.setActions(new String[]{"Save", "Cancel"});
        this.getUIStringInput(FIELD_NAME).setValue(null);
        this.getUIStringInput(FIELD_TITLE).setValue(null);
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIFolderForm> {
        public void execute(Event<UIFolderForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIFolderForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIFolderForm> {
        public void execute(Event<UIFolderForm> event) throws Exception {
            UIFolderForm uiFolderForm = (UIFolderForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiFolderForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiFolderForm.getAncestorOfType(UIApplication.class);
            String name = (String)uiFolderForm.getUIStringInput(UIFolderForm.FIELD_NAME).getValue();
            String title = (String)uiFolderForm.getUIStringInput(UIFolderForm.FIELD_TITLE).getValue();
            Node node = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(node)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (name == null || name.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.name-invalid", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (title == null || title.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.title-invalid", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String type = null;
            type = uiFolderForm.getUIFormSelectBox(UIFolderForm.FIELD_TYPE) != null ? (String)uiFolderForm.getUIFormSelectBox(UIFolderForm.FIELD_TYPE).getValue() : uiFolderForm.allowCreateFolder_;
            name = name.trim();
            title = title.trim();
            try {
                Node addedNode = node.addNode(Text.escapeIllegalJcrChars((String)name), type);
                if (!addedNode.hasProperty("exo:title")) {
                    addedNode.addMixin("exo:rss-enable");
                }
                addedNode.setProperty("exo:title", title);
                node.getSession().save();
                if (!uiExplorer.getPreference().isJcrEnable()) {
                    node.getSession().save();
                }
                uiExplorer.updateAjax(event);
            }
            catch (ConstraintViolationException cve) {
                Object[] arg = new Object[]{type};
                throw new MessageException(new ApplicationMessage("UIFolderForm.msg.constraint-violation", arg, 1));
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.repository-exception-permission", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (RepositoryException re) {
                NodeDefinition[] definitions;
                String key = "";
                for (NodeDefinition def : definitions = node.getPrimaryNodeType().getChildNodeDefinitions()) {
                    key = node.hasNode(name) || !def.allowsSameNameSiblings() ? "UIFolderForm.msg.not-allow-sameNameSibling" : "UIFolderForm.msg.repository-exception";
                }
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (NumberFormatException nume) {
                String key = "UIFolderForm.msg.numberformat-exception";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
        }
    }
}

