/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISavedQuery;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeOptionActionListener.class})})
public class UIJCRAdvancedSearch
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_QUERY = "query";
    public static final String FIELD_SELECT_BOX = "selectBox";
    private static final String ROOT_SQL_QUERY = "select * from nt:base order by exo:dateCreated DESC";
    private static final String SQL_QUERY = "select * from nt:base where jcr:path like '$0/%' order by exo:dateCreated DESC";
    private static final String ROOT_XPATH_QUERY = "//* order by @exo:dateCreated descending";
    private static final String XPATH_QUERY = "/jcr:root$0//* order by @exo:dateCreated descending";
    private static final String CHANGE_OPTION = "ChangeOption";
    private boolean isEdit_ = false;
    private String queryPath_;
    private String queryStatement_;
    private String queryLanguage_;

    public UIJCRAdvancedSearch() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption("SQL", (Object)"sql"));
        ls.add(new SelectItemOption("xPath", (Object)"xpath"));
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_SELECT_BOX, FIELD_SELECT_BOX, ls);
        uiSelectBox.setOnChange("Change");
        this.addUIFormInput((UIFormInput)uiSelectBox);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_QUERY, FIELD_QUERY, null));
        this.setActions(new String[]{"Search", "Save", "Cancel"});
    }

    public void update(Query query) throws Exception {
        if (query == null) {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            Node selectedNode = uiExplorer.getCurrentNode();
            String path = selectedNode.getPath();
            String queryText = StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)path);
            if ("/".equals(path)) {
                queryText = ROOT_SQL_QUERY;
            }
            this.getUIStringInput(FIELD_NAME).setValue(null);
            this.getUIStringInput(FIELD_NAME).setEditable(true);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setOnChange(CHANGE_OPTION);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setValue("sql");
            this.getUIFormTextAreaInput(FIELD_QUERY).setValue((Object)queryText);
        } else {
            String storedPath;
            this.queryPath_ = storedPath = query.getStoredQueryPath();
            storedPath = storedPath.substring(storedPath.lastIndexOf("/") + 1, storedPath.length());
            this.getUIStringInput(FIELD_NAME).setValue((Object)storedPath);
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setOnChange(CHANGE_OPTION);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setValue(query.getLanguage());
            this.getUIFormTextAreaInput(FIELD_QUERY).setValue((Object)query.getStatement());
        }
    }

    public void setQuery(Query query) {
        if (query != null) {
            this.queryLanguage_ = query.getLanguage();
            this.queryStatement_ = query.getStatement();
        } else {
            this.queryLanguage_ = null;
            this.queryStatement_ = null;
        }
    }

    public void setIsEdit(boolean isEdit) {
        this.isEdit_ = isEdit;
    }

    public boolean isEdit() {
        return this.isEdit_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIJCRAdvancedSearch> {
        public void execute(Event<UIJCRAdvancedSearch> event) throws Exception {
            UIJCRAdvancedSearch uiForm = (UIJCRAdvancedSearch)((Object)event.getSource());
            String statement = (String)uiForm.getUIFormTextAreaInput(UIJCRAdvancedSearch.FIELD_QUERY).getValue();
            String queryLang = (String)uiForm.getUIFormSelectBox(UIJCRAdvancedSearch.FIELD_SELECT_BOX).getValue();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (statement == null || statement.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIJCRAdvancedSearch.msg.value-save-null", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (!uiForm.isEdit_) {
                String[] arrFilterChar;
                QueryService queryService = (QueryService)uiForm.getApplicationComponent(QueryService.class);
                String name = (String)uiForm.getUIStringInput(UIJCRAdvancedSearch.FIELD_NAME).getValue();
                if (name == null || name.trim().length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UIJCRAdvancedSearch.msg.query-name-null", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\\", "\""}) {
                    if (name.indexOf(filterChar) <= -1) continue;
                    uiApp.addMessage(new ApplicationMessage("UIJCRAdvancedSearch.msg.name-invalid", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                String userName = Util.getPortalRequestContext().getRemoteUser();
                try {
                    queryService.addQuery(name, statement, queryLang, userName);
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIJCRAdvancedSearch.msg.save_unSuccessful", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                UIECMSearch uiSearch = (UIECMSearch)uiForm.getParent();
                ((UISavedQuery)uiSearch.getChild(UISavedQuery.class)).updateGrid(1);
                uiForm.update(null);
                uiSearch.setRenderedChild(UISavedQuery.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearch);
            } else {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
                QueryManager queryManager = uiExplorer.getTargetSession().getWorkspace().getQueryManager();
                try {
                    queryManager.createQuery(statement, queryLang);
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIJCRAdvancedSearch.msg.save_unSuccessful", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                ManageableRepository repository = ((RepositoryService)uiForm.getApplicationComponent(RepositoryService.class)).getRepository(uiExplorer.getRepositoryName());
                Session session = repository.getSystemSession(repository.getConfiguration().getDefaultWorkspaceName());
                Node queryNode = (Node)session.getItem(uiForm.queryPath_);
                queryNode.setProperty("jcr:language", queryLang);
                queryNode.setProperty("jcr:statement", statement);
                queryNode.save();
                if (!uiExplorer.getPreference().isJcrEnable()) {
                    session.save();
                }
                session.logout();
                UISavedQuery uiSavedQuery = (UISavedQuery)uiForm.getAncestorOfType(UISavedQuery.class);
                uiSavedQuery.updateGrid(1);
                uiSavedQuery.removeChildById("EditSavedQueryForm");
                event.getRequestContext().addUIComponentToUpdateByAjax(uiSavedQuery.getParent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeOptionActionListener
    extends EventListener<UIJCRAdvancedSearch> {
        public void execute(Event<UIJCRAdvancedSearch> event) throws Exception {
            UIJCRAdvancedSearch uiForm = (UIJCRAdvancedSearch)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            String currentPath = uiExplorer.getCurrentNode().getPath();
            String queryText = "";
            String searchType = (String)uiForm.getUIFormSelectBox(UIJCRAdvancedSearch.FIELD_SELECT_BOX).getValue();
            if (searchType.equals("sql")) {
                queryText = "/".equals(currentPath) ? UIJCRAdvancedSearch.ROOT_SQL_QUERY : StringUtils.replace((String)UIJCRAdvancedSearch.SQL_QUERY, (String)"$0", (String)currentPath);
                uiForm.getUIFormTextAreaInput(UIJCRAdvancedSearch.FIELD_QUERY).setValue((Object)queryText);
            } else {
                queryText = "/".equals(currentPath) ? UIJCRAdvancedSearch.ROOT_XPATH_QUERY : StringUtils.replace((String)UIJCRAdvancedSearch.XPATH_QUERY, (String)"$0", (String)currentPath);
                uiForm.getUIFormTextAreaInput(UIJCRAdvancedSearch.FIELD_QUERY).setValue((Object)queryText);
            }
            if (uiForm.isEdit_ && uiForm.queryLanguage_ != null && searchType.equals(uiForm.queryLanguage_)) {
                uiForm.getUIFormTextAreaInput(UIJCRAdvancedSearch.FIELD_QUERY).setValue((Object)uiForm.queryStatement_);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIJCRAdvancedSearch> {
        public void execute(Event<UIJCRAdvancedSearch> event) throws Exception {
            UIJCRAdvancedSearch uiForm = (UIJCRAdvancedSearch)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            String queryS = (String)uiForm.getUIFormTextAreaInput(UIJCRAdvancedSearch.FIELD_QUERY).getValue();
            String searchType = (String)uiForm.getUIFormSelectBox(UIJCRAdvancedSearch.FIELD_SELECT_BOX).getValue();
            UIECMSearch uiSearch = (UIECMSearch)uiForm.getParent();
            long startTime = System.currentTimeMillis();
            try {
                if (queryS.toLowerCase().indexOf("order by") < 0) {
                    if (searchType.equals("sql")) {
                        queryS = queryS + " order by exo:dateCreated DESC";
                    } else if (searchType.equals("xpath")) {
                        queryS = queryS + " order by @exo:dateCreated descending";
                    }
                }
                UISearchResult uiSearchResult = (UISearchResult)uiSearch.getChild(UISearchResult.class);
                uiSearchResult.setQuery(queryS, uiExplorer.getTargetSession().getWorkspace().getName(), searchType, IdentityConstants.SYSTEM.equals(uiExplorer.getTargetSession().getUserID()), null);
                uiSearchResult.updateGrid();
                long time = System.currentTimeMillis() - startTime;
                uiSearchResult.setSearchTime(time);
                uiSearch.setRenderedChild(UIECMSearch.ADVANCED_RESULT);
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJCRAdvancedSearch.msg.invalid-queryStatement", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIJCRAdvancedSearch> {
        public void execute(Event<UIJCRAdvancedSearch> event) throws Exception {
            UIJCRAdvancedSearch uiJAdvancedSearch = (UIJCRAdvancedSearch)((Object)event.getSource());
            if (uiJAdvancedSearch.isEdit_) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiJAdvancedSearch.getParent();
                uiPopup.setShow(false);
                uiPopup.setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiJAdvancedSearch.getParent());
            } else {
                ((UIPopupContainer)uiJAdvancedSearch.getAncestorOfType(UIPopupContainer.class)).deActivate();
                ((UIJCRExplorer)uiJAdvancedSearch.getAncestorOfType(UIJCRExplorer.class)).cancelAction();
            }
        }
    }
}

