/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadContainer;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadContent;
import org.exoplatform.ecm.webui.component.explorer.upload.UISingleUploadManager;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UISingleExternalMetadataForm
extends UIForm {
    public void renderExternalList() throws Exception {
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        for (NodeType nodeType : metadataService.getAllMetadatasNodeType()) {
            UIFormCheckBoxInput uiCheckBox = new UIFormCheckBoxInput(nodeType.getName(), nodeType.getName(), (Object)"");
            if (this.isInternalUse(nodeType)) continue;
            if (this.hasExternalMetadata(nodeType.getName())) {
                uiCheckBox.setChecked(true);
                uiCheckBox.setEnable(false);
            } else {
                uiCheckBox.setChecked(false);
                uiCheckBox.setEnable(true);
            }
            this.addUIFormInput((UIFormInput)uiCheckBox);
        }
    }

    private boolean isInternalUse(NodeType nodeType) throws Exception {
        for (PropertyDefinition pro : nodeType.getPropertyDefinitions()) {
            if (!pro.getName().equals("exo:internalUse")) continue;
            return pro.getDefaultValues()[0].getBoolean();
        }
        return false;
    }

    private boolean hasExternalMetadata(String name) throws Exception {
        UISingleUploadManager uiUploadManager = (UISingleUploadManager)this.getAncestorOfType(UISingleUploadManager.class);
        UISingleUploadContainer uiUploadContainer = (UISingleUploadContainer)uiUploadManager.getChild(UISingleUploadContainer.class);
        Node uploaded = uiUploadContainer.getUploadedNode();
        for (NodeType mixin : uploaded.getMixinNodeTypes()) {
            if (!mixin.getName().equals(name)) continue;
            return true;
        }
        if (uploaded.hasNode("jcr:content")) {
            for (NodeType mixin : uploaded.getNode("jcr:content").getMixinNodeTypes()) {
                if (!mixin.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UIExternalMetadataForm.label." + id);
        }
        catch (MissingResourceException ex) {
            return '_' + id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UISingleExternalMetadataForm> {
        public void execute(Event<UISingleExternalMetadataForm> event) throws Exception {
            UISingleExternalMetadataForm uiExternalMetadataForm = (UISingleExternalMetadataForm)((Object)event.getSource());
            ArrayList listCheckbox = new ArrayList();
            uiExternalMetadataForm.findComponentOfType(listCheckbox, UIFormCheckBoxInput.class);
            UISingleUploadManager uiUploadManager = (UISingleUploadManager)((UISingleExternalMetadataForm)((Object)event.getSource())).getAncestorOfType(UISingleUploadManager.class);
            UISingleUploadContainer uiContainer = (UISingleUploadContainer)uiUploadManager.getChild(UISingleUploadContainer.class);
            String metadataName = null;
            Node uploadedNode = uiContainer.getUploadedNode();
            for (int i = 0; i < listCheckbox.size(); ++i) {
                if (!((UIFormCheckBoxInput)listCheckbox.get(i)).isChecked() || !((UIFormCheckBoxInput)listCheckbox.get(i)).isEnable()) continue;
                metadataName = ((UIFormCheckBoxInput)listCheckbox.get(i)).getName();
                if (!uploadedNode.canAddMixin(metadataName)) {
                    UIApplication uiApp = (UIApplication)uiExternalMetadataForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIExternalMetadataForm.msg.can-not-add", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                uploadedNode.addMixin(metadataName);
                uploadedNode.save();
                UISingleUploadContent uiUploadContent = (UISingleUploadContent)uiContainer.getChild(UISingleUploadContent.class);
                uiUploadContent.externalList_.add(metadataName);
            }
            uploadedNode.getSession().save();
            UIPopupWindow uiPopup = (UIPopupWindow)uiUploadManager.getChildById("AddMetadataPopup");
            uiPopup.setShow(true);
            uiPopup.setRendered(false);
            uiPopup.setShowMask(true);
            uiContainer.setRenderedChild(UISingleUploadContent.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISingleExternalMetadataForm> {
        public void execute(Event<UISingleExternalMetadataForm> event) throws Exception {
            UISingleUploadManager uiUploadManager = (UISingleUploadManager)((UISingleExternalMetadataForm)((Object)event.getSource())).getAncestorOfType(UISingleUploadManager.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiUploadManager.getChildById("AddMetadataPopup");
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadManager);
        }
    }
}

