/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.SimpleJCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.UserByGroupJCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.UserByQueryJCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.UserImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.ExtendedUserHandler;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserEventListenerHandler;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.PasswordEncrypter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserHandlerImpl
extends CommonHandler
implements UserHandler,
UserEventListenerHandler,
ExtendedUserHandler {
    public static final String JOS_CREATED_DATE = "jos:createdDate";
    public static final String JOS_EMAIL = "jos:email";
    public static final String JOS_FIRST_NAME = "jos:firstName";
    public static final String JOS_LAST_LOGIN_TIME = "jos:lastLoginTime";
    public static final String JOS_LAST_NAME = "jos:lastName";
    public static final String JOS_MEMBERSHIP = "jos:membership";
    public static final String JOS_PASSWORD = "jos:password";
    public static final String JOS_PROFILE = "jos:profile";
    public static final String STORAGE_JOS_USERS = "jos:users";
    protected final List<UserEventListener> listeners = new ArrayList<UserEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.UserHandlerImpl");

    UserHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addUserEventListener(UserEventListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            boolean bl = this.authenticate(session, username, password, null);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password, PasswordEncrypter pe) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            boolean bl = this.authenticate(session, username, password, pe);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    private boolean authenticate(Session session, String username, String password, PasswordEncrypter pe) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.authenticate method is started");
        }
        try {
            boolean authenticated;
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_USERS + "/" + username);
            if (pe == null) {
                authenticated = this.readStringProperty(uNode, JOS_PASSWORD).equals(password);
            } else {
                String encryptedPassword = new String(pe.encrypt(this.readStringProperty(uNode, JOS_PASSWORD).getBytes()));
                authenticated = encryptedPassword.equals(password);
            }
            if (authenticated) {
                uNode.setProperty(JOS_LAST_LOGIN_TIME, Calendar.getInstance());
            }
            return authenticated;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not authenticate user '" + username + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(User user, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.createUser(session, user, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void createUser(Session session, User user, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUser method is started");
        }
        try {
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_USERS);
            Node uNode = storageNode.addNode(user.getUserName());
            if (user.getCreatedDate() == null) {
                Calendar calendar = Calendar.getInstance();
                user.setCreatedDate(calendar.getTime());
            }
            if (broadcast) {
                this.preSave(user, true);
            }
            this.writeObjectToNode(user, uNode);
            session.save();
            if (broadcast) {
                this.postSave(user, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create user '" + user.getUserName() + "'", e);
        }
    }

    public User createUserInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUserInstance() method is started");
        }
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUserInstance(String) method is started");
        }
        return new UserImpl(username);
    }

    User findUserByName(Session session, String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.findUserByName method is started");
        }
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_USERS + "/" + userName);
            return this.readObjectFromNode(uNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user '" + userName + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserByName(String userName) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            User user = this.findUserByName(session, userName);
            return user;
        }
        finally {
            session.logout();
        }
    }

    public LazyPageList findUsers(Query query) throws Exception {
        return new LazyPageList((ListAccess)new UserByQueryJCRUserListAccess(this.service, query), 10);
    }

    public LazyPageList findUsersByGroup(String groupId) throws Exception {
        return new LazyPageList((ListAccess)new UserByGroupJCRUserListAccess(this.service, groupId), 10);
    }

    public LazyPageList getUserPageList(int pageSize) throws Exception {
        return new LazyPageList((ListAccess)new SimpleJCRUserListAccess(this.service), pageSize);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        return new SimpleJCRUserListAccess(this.service);
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        return new UserByGroupJCRUserListAccess(this.service, groupId);
    }

    public ListAccess<User> findUsersByQuery(Query query) throws Exception {
        return new UserByQueryJCRUserListAccess(this.service, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User removeUser(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            User user = this.removeUser(session, userName, broadcast);
            return user;
        }
        finally {
            session.logout();
        }
    }

    private User removeUser(Session session, String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.removeUser method is started");
        }
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_USERS + "/" + userName);
            User user = this.readObjectFromNode(uNode);
            if (broadcast) {
                this.preDelete(user);
            }
            uNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(user);
            }
            return user;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove user '" + userName + "'", e);
        }
    }

    public void removeUserEventListener(UserEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUser(User user, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.saveUser(session, user, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void saveUser(Session session, User user, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.saveUser method is started");
        }
        try {
            UserImpl userImpl = (UserImpl)user;
            String userUUID = userImpl.getUUId() != null ? userImpl.getUUId() : ((UserImpl)this.findUserByName(session, user.getUserName())).getUUId();
            Node uNode = session.getNodeByUUID(userUUID);
            String srcPath = uNode.getPath();
            int pos = srcPath.lastIndexOf(47);
            String prevName = srcPath.substring(pos + 1);
            if (!prevName.equals(user.getUserName())) {
                String destPath = srcPath.substring(0, pos) + "/" + user.getUserName();
                session.move(srcPath, destPath);
                uNode = (Node)session.getItem(destPath);
            }
            if (broadcast) {
                this.preSave(user, false);
            }
            this.writeObjectToNode(user, uNode);
            session.save();
            if (broadcast) {
                this.postSave(user, false);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save user '" + user.getUserName() + "'", e);
        }
    }

    public User readObjectFromNode(Node node) throws Exception {
        try {
            UserImpl user = new UserImpl(node.getName(), node.getUUID());
            user.setCreatedDate(this.readDateProperty(node, JOS_CREATED_DATE));
            user.setLastLoginTime(this.readDateProperty(node, JOS_LAST_LOGIN_TIME));
            user.setEmail(this.readStringProperty(node, JOS_EMAIL));
            user.setPassword(this.readStringProperty(node, JOS_PASSWORD));
            user.setFirstName(this.readStringProperty(node, JOS_FIRST_NAME));
            user.setLastName(this.readStringProperty(node, JOS_LAST_NAME));
            return user;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read user properties", e);
        }
    }

    private void writeObjectToNode(User user, Node node) throws Exception {
        try {
            Calendar calendar = null;
            node.setProperty(JOS_EMAIL, user.getEmail());
            node.setProperty(JOS_FIRST_NAME, user.getFirstName());
            node.setProperty(JOS_LAST_NAME, user.getLastName());
            node.setProperty(JOS_PASSWORD, user.getPassword());
            if (user.getLastLoginTime() == null) {
                node.setProperty(JOS_LAST_LOGIN_TIME, calendar);
            } else {
                calendar = Calendar.getInstance();
                calendar.setTime(user.getLastLoginTime());
                node.setProperty(JOS_LAST_LOGIN_TIME, calendar);
            }
            calendar = Calendar.getInstance();
            calendar.setTime(user.getCreatedDate());
            node.setProperty(JOS_CREATED_DATE, calendar);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write user properties", e);
        }
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postDelete(user);
        }
    }

    private String removeAsterix(String str) {
        if (str.startsWith("*")) {
            str = str.substring(1);
        }
        if (str.endsWith("*")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public List<UserEventListener> getUserListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

