/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CajaCssSanitizer {
    private static final Logger LOG = Logger.getLogger(CajaCssSanitizer.class.getName());
    private static final Set<String> ALLOWED_URI_SCHEMES = ImmutableSet.of((Object)"http", (Object)"https");
    private final CajaCssParser parser;
    private final CssSchema schema;

    @Inject
    public CajaCssSanitizer(CajaCssParser parser) {
        this.parser = parser;
        this.schema = CssSchema.getDefaultCss21Schema((MessageQueue)new SimpleMessageQueue());
    }

    public String sanitize(String content, Uri linkContext, GadgetContext gadgetContext, ProxyUriManager importRewriter, ProxyUriManager imageRewriter) {
        try {
            CssTree.StyleSheet stylesheet = this.parser.parseDom(content, linkContext);
            this.sanitize((CssTree)stylesheet, linkContext, gadgetContext, importRewriter, imageRewriter);
            return this.parser.serialize(stylesheet);
        }
        catch (GadgetException ge) {
            LOG.log(Level.INFO, "Failed to parse stylesheet", ge);
            return "";
        }
    }

    public void sanitize(Element styleElem, Uri linkContext, GadgetContext gadgetContext, ProxyUriManager importRewriter, ProxyUriManager imageRewriter) {
        String content = null;
        try {
            CssTree.StyleSheet stylesheet = this.parser.parseDom(styleElem.getTextContent(), linkContext);
            this.sanitize((CssTree)stylesheet, linkContext, gadgetContext, importRewriter, imageRewriter);
            content = this.parser.serialize(stylesheet);
        }
        catch (GadgetException ge) {
            LOG.log(Level.INFO, "Failed to parse stylesheet", ge);
        }
        if (StringUtils.isEmpty(content)) {
            styleElem.getParentNode().removeChild(styleElem);
        } else {
            styleElem.setTextContent(content);
        }
    }

    public void sanitize(CssTree css, final Uri linkContext, final GadgetContext gadgetContext, final ProxyUriManager importRewriter, final ProxyUriManager imageRewriter) {
        css.acceptPreOrder(new Visitor(){

            public boolean visit(AncestorChain<?> ancestorChain) {
                if (ancestorChain.node instanceof CssTree.Property) {
                    if (!CajaCssSanitizer.this.schema.isPropertyAllowed(((CssTree.Property)ancestorChain.node).getPropertyName())) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Removing property " + ((CssTree.Property)ancestorChain.node).getPropertyName());
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                } else if (ancestorChain.node instanceof CssTree.FunctionCall) {
                    if (!CajaCssSanitizer.this.schema.isFunctionAllowed(((CssTree.FunctionCall)ancestorChain.node).getName())) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Removing function " + ((CssTree.FunctionCall)ancestorChain.node).getName());
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                } else if (ancestorChain.node instanceof CssTree.UriLiteral && !(ancestorChain.getParentNode() instanceof CssTree.Import)) {
                    String uri = ((CssTree.UriLiteral)ancestorChain.node).getValue();
                    if (CajaCssSanitizer.this.isValidUri(uri)) {
                        ((CssTree.UriLiteral)ancestorChain.node).setValue(CajaCssSanitizer.rewriteUri(imageRewriter, uri, linkContext, gadgetContext));
                    } else {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Removing invalid URI " + uri);
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                } else if (ancestorChain.node instanceof CssTree.Import) {
                    CssTree.Import importDecl = (CssTree.Import)ancestorChain.node;
                    String uri = importDecl.getUri().getValue();
                    if (CajaCssSanitizer.this.isValidUri(uri)) {
                        importDecl.getUri().setValue(CajaCssSanitizer.rewriteUri(importRewriter, uri, linkContext, gadgetContext));
                    } else {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Removing invalid URI " + uri);
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                }
                return true;
            }
        }, null);
    }

    private static String rewriteUri(ProxyUriManager proxyUriManager, String input, final Uri context, GadgetContext gadgetContext) {
        Uri inboundUri = null;
        try {
            inboundUri = Uri.parse((String)input);
        }
        catch (IllegalArgumentException e) {
            return input;
        }
        if (context != null) {
            inboundUri = context.resolve(inboundUri);
        }
        ImmutableList uris = ImmutableList.of((Object)new ProxyUriManager.ProxyUri(DomWalker.makeGadget(new GadgetContext(gadgetContext){

            public Uri getUrl() {
                return context;
            }
        }), inboundUri));
        List<Uri> rewritten = proxyUriManager.make((List<ProxyUriManager.ProxyUri>)uris, null);
        return rewritten.get(0).toString();
    }

    private boolean isValidUri(String uri) {
        try {
            String scheme = Uri.parse((String)uri).getScheme();
            return StringUtils.isEmpty((String)scheme) || ALLOWED_URI_SCHEMES.contains(scheme.toLowerCase());
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Failed to parse URI in CSS " + uri, re);
            }
            return false;
        }
    }

    private static void clean(AncestorChain<?> chain) {
        if (chain.node instanceof CssTree.Declaration || chain.node instanceof CssTree.Import) {
            if (chain.getParentNode() instanceof CssTree.UserAgentHack) {
                CajaCssSanitizer.clean(chain.parent);
            } else {
                ((AbstractParseTreeNode)chain.getParentNode()).removeChild(chain.node);
            }
        } else {
            CajaCssSanitizer.clean(chain.parent);
        }
    }
}

