/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.MethodInvocation;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstInvocation;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstMethod
extends AstInvocation {
    private final AstProperty property;

    public AstMethod(AstProperty property, List<AstNode> nodes, boolean varargs) {
        super(nodes, varargs);
        this.property = property;
    }

    protected Method resolveMethod(ELContext context, Object base, final String name) throws MethodNotFoundException {
        Object value = null;
        try {
            context.setPropertyResolved(false);
            value = context.getELResolver().getValue(context, base, (Object)new MethodInvocation(){

                public String getName() {
                    return name;
                }

                public int getParamCount() {
                    return AstMethod.this.getParamCount();
                }

                public boolean isVarArgs() {
                    return AstMethod.this.isVarArgs();
                }

                public String toString() {
                    return this.getName();
                }
            });
        }
        catch (PropertyNotFoundException e) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", name, base.getClass()));
        }
        if (!context.isPropertyResolved()) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", name, base.getClass()));
        }
        Method method = null;
        if (value instanceof Method) {
            method = (Method)value;
        } else if (value instanceof MethodInfo) {
            try {
                method = value.getClass().getMethod(name, ((MethodInfo)value).getParamTypes());
            }
            catch (NoSuchMethodException e) {
                throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, base.getClass()), (Throwable)e);
            }
        } else {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, base.getClass()));
        }
        return method;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Object base = this.getBase().eval(bindings, context);
        if (base == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.base.null", this.getBase()));
        }
        String name = this.getName(bindings, context);
        if (name == null || name.length() == 0) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, base.getClass()));
        }
        Method method = this.resolveMethod(context, base, name);
        if (this.varargs && method.isVarArgs() ? method.getParameterTypes().length > this.getParamCount() + 1 : method.getParameterTypes().length != this.getParamCount()) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()));
        }
        try {
            return this.invoke(bindings, context, base, method);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.property.method.access", name, base.getClass()));
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()), e.getCause());
        }
    }

    public String toString() {
        return "(...)";
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        this.property.appendStructure(b, bindings);
        b.append("(");
        if (this.nodes != null && this.nodes.size() > 0) {
            ((AstNode)this.nodes.get(0)).appendStructure(b, bindings);
            for (int i = 1; i < this.nodes.size(); ++i) {
                b.append(", ");
                ((AstNode)this.nodes.get(i)).appendStructure(b, bindings);
            }
        }
        b.append(")");
    }

    protected AstNode getBase() {
        return this.property.getChild(0);
    }

    protected String getName(Bindings bindings, ELContext context) {
        return bindings.convert(this.property.getProperty(bindings, context), String.class);
    }

    @Override
    public int getCardinality() {
        return 1 + this.getParamCount();
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.property : this.getParam(i - 1);
    }
}

