/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.auditing;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.lock.LockException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(type=UIActivateAuditing.class, template="app:/groovy/webui/component/explorer/auditing/UIActivateAuditing.gtmpl", events={@EventConfig(listeners={EnableAuditingActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIActivateAuditing
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIActivateAuditing");

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIActivateAuditing> {
        public void execute(Event<UIActivateAuditing> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIActivateAuditing)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnableAuditingActionListener
    extends EventListener<UIActivateAuditing> {
        public void execute(Event<UIActivateAuditing> event) throws Exception {
            try {
                UIActivateAuditing uiActivateAuditing = (UIActivateAuditing)((Object)event.getSource());
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActivateAuditing.getAncestorOfType(UIJCRExplorer.class);
                Node currentNode = uiExplorer.getCurrentNode();
                currentNode.addMixin("exo:auditable");
                AuditService auditService = (AuditService)WCMCoreUtils.getService(AuditService.class);
                if (!auditService.hasHistory(currentNode)) {
                    auditService.createHistory(currentNode);
                }
                currentNode.save();
                currentNode.getSession().save();
                currentNode.getSession().refresh(true);
                uiExplorer.updateAjax(event);
            }
            catch (LockException lockException) {
                UIActivateAuditing uiActivateAuditing = (UIActivateAuditing)((Object)event.getSource());
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActivateAuditing.getAncestorOfType(UIJCRExplorer.class);
                WebuiRequestContext contx = event.getRequestContext();
                UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
                Object[] arg = new Object[]{uiExplorer.getCurrentNode().getPath()};
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            }
            catch (AccessDeniedException accessDeniedException) {
                UIActivateAuditing uiActivateAuditing = (UIActivateAuditing)((Object)event.getSource());
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActivateAuditing.getAncestorOfType(UIJCRExplorer.class);
                WebuiRequestContext contx = event.getRequestContext();
                UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                UIActivateAuditing uiActivateAuditing = (UIActivateAuditing)((Object)event.getSource());
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActivateAuditing.getAncestorOfType(UIJCRExplorer.class);
                WebuiRequestContext contx = event.getRequestContext();
                UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.does-not-support-auditing", null, 1));
            }
        }
    }
}

