/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.CommentParser;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ParseException;
import com.google.caja.util.CajaTestCase;

public class CommentParserTest
extends CajaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testEmptyComment() throws Exception {
        this.assertComment("(Comment)", "/***/");
        this.assertComment("(Comment)", "/****/");
        this.assertComment("(Comment)", "/*******************/");
    }

    public final void testTextOnly() throws Exception {
        this.assertComment("(Comment (TextAnnotation 'Hello World '))", "/** Hello World */");
    }

    public final void testLineBreaking() throws Exception {
        this.assertComment("(Comment (TextAnnotation 'Hello\nWorld\n'))", "/** Hello\n * World\n */");
        this.assertComment("(Comment (TextAnnotation 'Hello\nWorld\n'))", "/** Hello\r\n * World\r */");
        this.assertComment("(Comment (TextAnnotation 'Hello\nWorld\n'))", "/** Hello\r\n ** World\r\n **/");
        this.assertComment("(Comment (TextAnnotation 'Hello\nWorld'))", "/**Hello\r\nWorld**/");
    }

    public final void testInlineAnnotationInBody() throws Exception {
        this.assertComment("(Comment (TextAnnotation 'Foo ') (InlineAnnotation 'code' (TextAnnotation '{{Bar{Baz}}}')) (TextAnnotation ' Boo '))", "/** Foo {@code {{Bar{Baz}}}} Boo */");
    }

    public final void testBlockAnnotations1() throws Exception {
        this.assertComment("(Comment (TextAnnotation 'Oh ') (BlockAnnotation 'see' (TextAnnotation 'can you say ')))", "/** Oh @see can you say */");
    }

    public final void testBlockAnnotations() throws Exception {
        this.assertComment("(Comment (TextAnnotation 'Oh ') (BlockAnnotation 'param' (TextAnnotation 'a foo ')) (BlockAnnotation 'param' (TextAnnotation 'b bar ')))", "/** Oh @param a foo @param b bar */");
    }

    public final void testMixedAnnotations() throws Exception {
        this.assertComment("(Comment (TextAnnotation 'Oh ') (InlineAnnotation 'link' (TextAnnotation 'zoicks')) (TextAnnotation ' ') (BlockAnnotation 'param' (TextAnnotation 'a foo ') (InlineAnnotation 'code' (TextAnnotation '{ baz: boo }')) (TextAnnotation ' bar ')))", "/** Oh {@link zoicks} @param a foo {@code { baz: boo }} bar */");
    }

    public final void testComplexComment() throws Exception {
        this.assertComment("(Comment (TextAnnotation '\n') (BlockAnnotation 'param' (TextAnnotation '{type} p blah blah.\n')) (BlockAnnotation 'return' (TextAnnotation '{Array.<type>} blah-dy blah\n  ') (InlineAnnotation 'code' (TextAnnotation '{x: \"}\", y: 3}')) (TextAnnotation '\n  given the input\n  ') (InlineAnnotation 'code' (TextAnnotation ''{\\'x=}&y=3\\'}'')) (TextAnnotation '\n')))", "/**\n * @param {type} p blah blah.\n * @return {Array.<type>} blah-dy blah\n *   {@code {x: \"}\", y: 3}}\n *   given the input\n *   {@code '{\\'x=}&y=3\\'}'}\n */");
    }

    public final void testSpecialCharsOutsideAnnotataion() throws Exception {
        this.assertComment("(Comment (TextAnnotation '@'))", "/*@*/");
        this.assertComment("(Comment (TextAnnotation '{@'))", "/*{@*/");
        this.assertComment("(Comment (TextAnnotation '{@}'))", "/*{@}*/");
        this.assertComment("(Comment (TextAnnotation '@') (BlockAnnotation 'a'))", "/*@@a*/");
    }

    public final void testEmailAddresses() throws Exception {
        this.assertComment("(Comment (BlockAnnotation 'author' (TextAnnotation 'first.last@host.tld ')))", "/* @author first.last@host.tld */");
    }

    private void assertComment(String golden, String commentText) throws ParseException {
        CharProducer cp = this.fromString(commentText);
        String actual = CommentParser.parseStructuredComment(cp).toString();
        CommentParserTest.assertEquals((String)actual.replace("\r", "\\r").replace("\n", "\\n"), (String)golden, (String)("" + actual));
    }
}

