/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.jbosscache;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.TemplateConfigurationHelper;
import org.exoplatform.services.jcr.jbosscache.JBossCacheHelper;
import org.exoplatform.services.jcr.jbosscache.PrivilegedJBossCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.jmx.JmxRegistrationManager;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoJBossCacheFactory<K, V> {
    public static final String JBOSSCACHE_CONFIG = "jbosscache-configuration";
    public static final String JGROUPS_CONFIG = "jgroups-configuration";
    public static final String JGROUPS_MUX_ENABLED = "jgroups-multiplexer-stack";
    private static final JChannelFactory CHANNEL_FACTORY = (JChannelFactory)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<JChannelFactory>(){

        @Override
        public JChannelFactory run() {
            return new JChannelFactory();
        }
    });
    private static Map<ExoContainer, Map<CacheType, Map<ConfigurationKey, CacheInstance>>> CACHES = new HashMap<ExoContainer, Map<CacheType, Map<ConfigurationKey, CacheInstance>>>();
    private final TemplateConfigurationHelper configurationHelper;
    private final TransactionManager transactionManager;
    private ConfigurationManager configurationManager;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ExoJBossCacheFactory");

    public ExoJBossCacheFactory(ConfigurationManager configurationManager, TransactionManager transactionManager) {
        this.configurationManager = configurationManager;
        this.configurationHelper = new JBossCacheHelper(configurationManager);
        this.transactionManager = transactionManager;
    }

    public ExoJBossCacheFactory(ConfigurationManager configurationManager) {
        this(configurationManager, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cache<K, V> createCache(MappedParametrizedObjectEntry parameterEntry) throws RepositoryConfigurationException {
        InputStream configStream;
        String jBossCacheConfigurationPath = parameterEntry.getParameterValue(JBOSSCACHE_CONFIG);
        LOG.info((Object)("JBoss Cache configuration used: " + jBossCacheConfigurationPath));
        try {
            configStream = this.configurationHelper.fillTemplate(jBossCacheConfigurationPath, parameterEntry.getParameters());
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException(e);
        }
        final CacheFactory factory = (CacheFactory)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<CacheFactory<K, V>>(){

            @Override
            public CacheFactory<K, V> run() {
                return new DefaultCacheFactory();
            }
        });
        final InputStream stream = configStream;
        PrivilegedAction action = new PrivilegedAction<Cache<K, V>>(){

            @Override
            public Cache<K, V> run() {
                return factory.createCache(stream, false);
            }
        };
        Cache cache = (Cache)SecurityHelper.doPrivilegedAction((PrivilegedAction)action);
        if (this.transactionManager != null) {
            cache.getConfiguration().getRuntimeConfig().setTransactionManager(this.transactionManager);
        }
        if (parameterEntry.getParameterBoolean(JGROUPS_MUX_ENABLED, false).booleanValue()) {
            try {
                String jgroupsConfigurationFilePath = parameterEntry.getParameterValue(JGROUPS_CONFIG);
                if (jgroupsConfigurationFilePath == null) return cache;
                CHANNEL_FACTORY.setMultiplexerConfig(this.configurationManager.getResource(jgroupsConfigurationFilePath));
                cache.getConfiguration().getRuntimeConfig().setMuxChannelFactory((ChannelFactory)CHANNEL_FACTORY);
                LOG.info((Object)"Multiplexer stack successfully enabled for the cache.");
                return cache;
            }
            catch (Exception e) {
                throw new RepositoryConfigurationException("Error setting multiplexer configuration.", e);
            }
        }
        String jgroupsConfigurationFilePath = parameterEntry.getParameterValue(JGROUPS_CONFIG, null);
        if (jgroupsConfigurationFilePath == null) return cache;
        try {
            cache.getConfiguration().setJgroupsConfigFile(this.configurationManager.getResource(jgroupsConfigurationFilePath));
            LOG.info((Object)("Custom JGroups configuration set:" + this.configurationManager.getResource(jgroupsConfigurationFilePath)));
            return cache;
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Error setting JGroups configuration.", e);
        }
    }

    private static <K, V> void addEvictionRegion(Fqn<String> fqn, Cache<K, V> cache, Configuration cfg) {
        EvictionConfig ec = cfg.getEvictionConfig();
        Region region = cache.getRegion(fqn, true);
        if (ec != null && ec.getDefaultEvictionRegionConfig() != null) {
            EvictionRegionConfig erc = new EvictionRegionConfig(fqn);
            erc.setDefaults(ec.getDefaultEvictionRegionConfig());
            region.setEvictionRegionConfig(erc);
        }
    }

    public static synchronized <K, V> Cache<K, V> getUniqueInstance(CacheType cacheType, Fqn<String> rootFqn, Cache<K, V> cache, boolean shareable) throws RepositoryConfigurationException {
        ConfigurationKey key;
        Map<ConfigurationKey, CacheInstance> caches;
        if (!shareable) {
            cache.getConfiguration().setClusterName(cache.getConfiguration().getClusterName() + rootFqn.toString().replace('/', '-'));
            return cache;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        Map<CacheType, Map<ConfigurationKey, CacheInstance>> allCacheTypes = CACHES.get(container);
        if (allCacheTypes == null) {
            allCacheTypes = new HashMap<CacheType, Map<ConfigurationKey, CacheInstance>>();
            CACHES.put(container, allCacheTypes);
        }
        if ((caches = allCacheTypes.get((Object)cacheType)) == null) {
            caches = new HashMap<ConfigurationKey, CacheInstance>();
            allCacheTypes.put(cacheType, caches);
        }
        Configuration cfg = cache.getConfiguration();
        try {
            key = new ConfigurationKey(cfg);
        }
        catch (CloneNotSupportedException e) {
            throw new RepositoryConfigurationException("Cannot clone the configuration.", e);
        }
        if (caches.containsKey(key)) {
            CacheInstance cacheInstance = caches.get(key);
            cacheInstance.acquire();
            cache = cacheInstance.cache;
        } else {
            CacheInstance cacheInstance = new CacheInstance(cache);
            cacheInstance.acquire();
            caches.put(key, cacheInstance);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("A new JBoss Cache instance has been registered for the region " + rootFqn + ", a cache of type " + (Object)((Object)cacheType) + " and the container " + container.getContext().getName()));
            }
        }
        ExoJBossCacheFactory.addEvictionRegion(rootFqn, cache, cfg);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The region " + rootFqn + " has been registered for a cache of type " + (Object)((Object)cacheType) + " and the container " + container.getContext().getName()));
        }
        return cache;
    }

    public static synchronized <K, V> void releaseUniqueInstance(CacheType cacheType, Cache<K, V> cache) throws RepositoryConfigurationException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        Map<CacheType, Map<ConfigurationKey, CacheInstance>> allCacheTypes = CACHES.get(container);
        Map<ConfigurationKey, CacheInstance> caches = allCacheTypes.get((Object)cacheType);
        Iterator<Map.Entry<ConfigurationKey, CacheInstance>> it = caches.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ConfigurationKey, CacheInstance> entry = it.next();
            CacheInstance cacheInstance = entry.getValue();
            if (!cacheInstance.isSame(cache)) continue;
            cacheInstance.release();
            if (cacheInstance.hasReferences()) continue;
            it.remove();
            if (caches.isEmpty()) {
                allCacheTypes.remove((Object)cacheType);
                if (allCacheTypes.isEmpty()) {
                    CACHES.remove(container);
                }
            }
            PrivilegedJBossCacheHelper.stop(cache);
        }
    }

    public static JmxRegistrationManager getJmxRegistrationManager(ExoContainerContext ctx, Cache<?, ?> parentCache, CacheType cacheType) {
        try {
            ObjectName containerObjectName = ctx.getContainer().getScopingObjectName();
            final String objectNameBase = containerObjectName.toString() + ",cache-type=" + (Object)((Object)cacheType);
            return new JmxRegistrationManager(ctx.getContainer().getMBeanServer(), parentCache, objectNameBase){

                public String getObjectName(String resourceName) {
                    return objectNameBase + ",jmx-resource=" + resourceName;
                }
            };
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Could not create the JMX Manager", (Throwable)e);
            return null;
        }
    }

    private static class CacheInstance {
        private final Cache cache;
        private int references;

        public CacheInstance(Cache cache) {
            this.cache = cache;
        }

        private void acquire() {
            ++this.references;
        }

        private void release() {
            --this.references;
        }

        private boolean hasReferences() {
            return this.references > 0;
        }

        private boolean isSame(Cache cache) {
            return this.cache == cache;
        }
    }

    private static class ConfigurationKey {
        private final String jgroupsConfigFile;
        private final Configuration conf;

        public ConfigurationKey(Configuration initialConf) throws CloneNotSupportedException {
            this.conf = initialConf.clone();
            this.jgroupsConfigFile = this.conf.getJGroupsConfigFile() == null ? null : this.conf.getJGroupsConfigFile().toString();
            this.conf.setJgroupsConfigFile(null);
            this.conf.setEvictionConfig(null);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conf == null ? 0 : this.conf.hashCode());
            result = 31 * result + (this.jgroupsConfigFile == null ? 0 : this.jgroupsConfigFile.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigurationKey other = (ConfigurationKey)obj;
            if (this.conf == null ? other.conf != null : !this.conf.equals((Object)other.conf)) {
                return false;
            }
            return !(this.jgroupsConfigFile == null ? other.jgroupsConfigFile != null : !this.jgroupsConfigFile.equals(other.jgroupsConfigFile));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheType {
        JCR_CACHE,
        INDEX_CACHE,
        LOCK_CACHE;

    }
}

