/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CRCGenerator {
    private static final String HEX = "0123456789abcdef";

    public static String getChecksum(InputStream in, String algo) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(algo);
        DigestInputStream digestInputStream = new DigestInputStream(in, md);
        digestInputStream.on(true);
        while (digestInputStream.read() > -1) {
            digestInputStream.read();
        }
        byte[] bytes = digestInputStream.getMessageDigest().digest();
        return CRCGenerator.generateString(bytes);
    }

    private static String generateString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            int v = b & 0xFF;
            sb.append(HEX.charAt(v >> 4));
            sb.append(HEX.charAt(v & 0xF));
        }
        return sb.toString();
    }
}

