/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.listeners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewGroupListener
extends GroupEventListener {
    private static final Log LOG = ExoLogger.getLogger((String)NewGroupListener.class.getName());
    private HierarchyConfig config_;
    private RepositoryService jcrService_;
    private String groupsPath_;
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    private static final String GROUPS_PATH = "groupsPath";

    public NewGroupListener(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreatorService, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.config_ = (HierarchyConfig)params.getObjectParamValues(HierarchyConfig.class).get(0);
        this.groupsPath_ = nodeHierarchyCreatorService.getJcrPath(GROUPS_PATH);
    }

    public void preSave(Group group, boolean isNew) throws Exception {
        this.buildGroupStructure(group);
    }

    public void preDelete(Group group) throws Exception {
        block2: {
            try {
                this.removeGroup(group.getId());
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)e.getMessage());
            }
        }
    }

    private void removeGroup(String groupId) throws Exception {
        ManageableRepository manageableRepository = this.jcrService_.getCurrentRepository();
        String systemWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = manageableRepository.getSystemSession(systemWorkspace);
        Node groupNode = (Node)session.getItem(this.groupsPath_ + groupId);
        groupNode.remove();
        session.save();
        session.logout();
    }

    private void buildGroupStructure(Group group) throws Exception {
        ManageableRepository manageableRepository = this.jcrService_.getCurrentRepository();
        String systemWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = manageableRepository.getSystemSession(systemWorkspace);
        Node groupsHome = (Node)session.getItem(this.groupsPath_);
        List jcrPaths = this.config_.getJcrPaths();
        String groupId = group.getId();
        String groupLabel = group.getLabel();
        Node groupNode = null;
        try {
            groupNode = groupsHome.getNode(groupId.substring(1, groupId.length()));
        }
        catch (PathNotFoundException e) {
            groupNode = groupsHome.addNode(groupId.substring(1, groupId.length()));
        }
        if (groupNode.canAddMixin("exo:driveMetadata")) {
            groupNode.addMixin("exo:driveMetadata");
        }
        groupNode.setProperty("exo:driveLabel", groupLabel);
        for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
            this.createNode(groupNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), this.getPermissions(jcrPath.getPermissions(), groupId));
        }
        session.save();
        session.logout();
    }

    private void createNode(Node groupNode, String path, String nodeType, List<String> mixinTypes, Map permissions) throws Exception {
        if (nodeType == null || nodeType.length() == 0) {
            nodeType = NT_UNSTRUCTURED;
        }
        try {
            groupNode = groupNode.getNode(path);
        }
        catch (PathNotFoundException e) {
            groupNode = groupNode.addNode(path, nodeType);
        }
        if (groupNode.canAddMixin("exo:privilegeable")) {
            groupNode.addMixin("exo:privilegeable");
        }
        if (permissions != null && !permissions.isEmpty()) {
            ((ExtendedNode)groupNode).setPermissions(permissions);
        }
        if (mixinTypes.size() > 0) {
            for (String mixin : mixinTypes) {
                if (!groupNode.canAddMixin(mixin)) continue;
                groupNode.addMixin(mixin);
            }
        }
    }

    private Map getPermissions(List<HierarchyConfig.Permission> permissions, String groupId) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        String groupIdentity = "*:".concat(groupId);
        permissionsMap.put(groupIdentity, PermissionType.ALL);
        for (HierarchyConfig.Permission permission : permissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }
}

