/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.fckeditor;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.connector.fckeditor.FCKFileHandler;
import org.exoplatform.ecm.connector.fckeditor.FCKFolderHandler;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.ecm.connector.fckeditor.FileUploadHandler;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/fckconnector/jcr/")
public class FCKCoreRESTConnector
implements ResourceContainer {
    private FCKFileHandler fileHandler;
    private FCKFolderHandler folderHandler;
    private FileUploadHandler fileUploadHandler;
    private ThreadLocalSessionProviderService sessionProviderService;
    private RepositoryService repositoryService;

    public FCKCoreRESTConnector(RepositoryService repositoryService, ThreadLocalSessionProviderService providerService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = providerService;
        this.fileHandler = new FCKFileHandler(ExoContainerContext.getCurrentContainer());
        this.folderHandler = new FCKFolderHandler(ExoContainerContext.getCurrentContainer());
        this.fileUploadHandler = new FileUploadHandler(ExoContainerContext.getCurrentContainer());
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getFoldersAndFiles(@QueryParam(value="repositoryName") String repoName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="command") String command, @QueryParam(value="type") String type) throws Exception {
        Session session = this.getSession(workspaceName);
        Node currentNode = (Node)session.getItem(currentFolder);
        String ftype = this.folderHandler.getFolderType(currentNode);
        if (ftype == null) {
            return Response.status((int)400).build();
        }
        Element root = FCKUtils.createRootElement(command, currentNode, ftype);
        Document document = root.getOwnerDocument();
        Element folders = root.getOwnerDocument().createElement("Folders");
        Element files = root.getOwnerDocument().createElement("Files");
        NodeIterator iterator = currentNode.getNodes();
        while (iterator.hasNext()) {
            String fileType;
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable")) continue;
            String folderType = this.folderHandler.getFolderType(child);
            if (folderType != null) {
                Element folder = this.folderHandler.createFolderElement(document, child, folderType);
                folders.appendChild(folder);
            }
            if ((fileType = this.fileHandler.getFileType(child, type)) == null) continue;
            Element file = this.fileHandler.createFileElement(document, child, fileType);
            files.appendChild(file);
        }
        root.appendChild(folders);
        root.appendChild(files);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok((Object)document, (MediaType)new MediaType("text", "xml")).cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/createFolder/")
    public Response createFolder(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="newFolderName") String newFolderName, @QueryParam(value="language") String language) throws Exception {
        Session session = this.getSession(workspaceName);
        Node currentNode = (Node)session.getItem(currentFolder);
        return this.folderHandler.createNewFolder(currentNode, newFolderName, language);
    }

    @POST
    @Path(value="/uploadFile/upload/")
    public Response uploadFile(@Context HttpServletRequest servletRequest) throws Exception {
        return this.fileUploadHandler.upload(servletRequest);
    }

    @GET
    @Path(value="/uploadFile/control/")
    public Response processUpload(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="action") String action, @QueryParam(value="language") String language, @QueryParam(value="fileName") String fileName, @QueryParam(value="uploadId") String uploadId) throws Exception {
        if ("save".equals(action)) {
            Session session = this.getSession(workspaceName);
            Node currentNode = (Node)session.getItem(currentFolder);
            return this.fileUploadHandler.saveAsNTFile(currentNode, uploadId, fileName, language);
        }
        return this.fileUploadHandler.control(uploadId, action);
    }

    private Session getSession(String workspaceName) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        if (workspaceName == null) {
            workspaceName = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        }
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        return sessionProvider.getSession(workspaceName, manageableRepository);
    }
}

