/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.scheduler.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ChangeStateCronJobImpl
implements Job {
    private static final Log LOG = ExoLogger.getLogger((String)ChangeStateCronJobImpl.class.getName());
    private static final String START_TIME_PROPERTY = "publication:startPublishedDate";
    private static final String END_TIME_PROPERTY = "publication:endPublishedDate";
    private static final int NORMAL_NODE = 0;
    private static final int STAGED_NODE = 1;
    private static int count = 0;
    private String fromState = null;
    private String toState = null;
    private String predefinedPath = null;
    private String workspace = null;
    private String contentPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SessionProvider sessionProvider = null;
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            if (mx.getUptime() > 120000L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Start Execute ChangeStateCronJob");
                }
                if (this.fromState == null) {
                    JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
                    this.fromState = jdatamap.getString("fromState");
                    this.toState = jdatamap.getString("toState");
                    this.predefinedPath = jdatamap.getString("predefinedPath");
                    String[] pathTab = this.predefinedPath.split(":");
                    this.workspace = pathTab[0];
                    this.contentPath = pathTab[1];
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Start Execute ChangeStateCronJob: change the State from " + this.fromState + " to " + this.toState));
                }
                sessionProvider = SessionProvider.createSystemProvider();
                String property = null;
                if ("staged".equals(this.fromState) && "published".equals(this.toState)) {
                    property = START_TIME_PROPERTY;
                } else if ("published".equals(this.fromState) && "unpublished".equals(this.toState)) {
                    property = END_TIME_PROPERTY;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                Date now = Calendar.getInstance().getTime();
                String currentTime = format.format(now);
                if (property != null) {
                    long stagedCount;
                    if (this.contentPath != null && !this.contentPath.endsWith("/")) {
                        this.contentPath = this.contentPath + "/";
                    }
                    StringBuilder normalNodesStatement = new StringBuilder().append("select * from nt:base where ").append("(publication:currentState='").append(this.fromState).append("') ").append(" and (").append(property).append(" IS NOT NULL )").append(" and (").append(property).append(" < TIMESTAMP '").append(currentTime).append("') ").append(" and (jcr:path like '").append(this.contentPath).append("%' )");
                    StringBuilder stagedNodesStatement = new StringBuilder().append("select * from nt:base where ").append("(publication:currentState='").append(this.fromState).append("') ").append(" and (").append(property).append(" IS NULL ) ").append(" and (jcr:path like '").append(this.contentPath).append("%' )");
                    long normalCount = this.changeStateForNodes(sessionProvider, property, 0, normalNodesStatement.toString());
                    long numberOfItemsToChange = normalCount + (stagedCount = START_TIME_PROPERTY.equals(property) ? this.changeStateForNodes(sessionProvider, property, 1, stagedNodesStatement.toString()) : 0L);
                    if (numberOfItemsToChange > 0L) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(numberOfItemsToChange + " '" + this.fromState + "' candidates for state '" + this.toState + "' found in " + this.predefinedPath));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("no '" + this.fromState + "' content found in " + this.predefinedPath));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"End Execute ChangeStateCronJob");
                }
            }
        }
        catch (RepositoryException ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Repository not found. Ignoring");
            }
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("error when changing the state of the content : " + ex.getMessage()), (Throwable)ex);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private long changeStateForNodes(SessionProvider sessionProvider, String property, int nodeType, String statement) throws Exception {
        long ret = 0L;
        RepositoryService repositoryService_ = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get("Authoring publication");
        HashMap<String, String> context_ = new HashMap<String, String>();
        ManageableRepository manageableRepository = repositoryService_.getCurrentRepository();
        if (manageableRepository == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ManageableRepository not found. Ignoring");
            }
            return 0L;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(statement, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            String path = "path not found";
            String nodeDateStr = "date not found";
            Node node_ = iter.nextNode();
            try {
                path = node_.getPath();
                if (path.startsWith("/jcr:system")) continue;
                if (0 == nodeType) {
                    Node liveRevision;
                    String liveRevisionProperty;
                    Date nodeDate = node_.getProperty(property).getDate().getTime();
                    nodeDateStr = format.format(nodeDate);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("'" + this.toState + "' " + node_.getPath() + " (" + property + "=" + nodeDateStr + ")"));
                    }
                    if ("unpublished".equals(this.toState) && node_.hasProperty("publication:liveRevision") && !"".equals(liveRevisionProperty = node_.getProperty("publication:liveRevision").getString()) && (liveRevision = session.getNodeByUUID(liveRevisionProperty)) != null) {
                        context_.put("Publication.context.currentVersion", liveRevision.getName());
                    }
                    publicationPlugin.changeState(node_, this.toState, context_);
                    ++ret;
                } else {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("'" + this.toState + "' " + node_.getPath()));
                    }
                    publicationPlugin.changeState(node_, this.toState, context_);
                }
                if (START_TIME_PROPERTY.equals(property) && node_.hasProperty(START_TIME_PROPERTY)) {
                    node_.getProperty(START_TIME_PROPERTY).remove();
                    node_.save();
                }
                if (!END_TIME_PROPERTY.equals(property) || !node_.hasProperty(END_TIME_PROPERTY)) continue;
                node_.getProperty(END_TIME_PROPERTY).remove();
                node_.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Exception while changing '" + this.toState + "' " + path + " (" + property + "=" + nodeDateStr + ")"), (Throwable)e);
            }
        }
        return ret;
    }
}

