/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.indexing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.impl.core.query.NodeDataIndexingIterator;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcNodeDataIndexingIterator
implements NodeDataIndexingIterator {
    private final GenericConnectionFactory connFactory;
    private final int pageSize;
    private final AtomicInteger offset = new AtomicInteger(0);
    private final AtomicBoolean hasNext = new AtomicBoolean(true);
    private final AtomicReference<String> lastNodeId = new AtomicReference<String>("");
    private final AtomicInteger page = new AtomicInteger();
    private final Lock lock = new ReentrantLock();
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JdbcIndexingDataIterator");

    public JdbcNodeDataIndexingIterator(GenericConnectionFactory connFactory, int pageSize) throws RepositoryException {
        this.connFactory = connFactory;
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeDataIndexing> next() throws RepositoryException {
        Object object;
        JDBCStorageConnection conn;
        block17: {
            int currentPage;
            String currentLastNodeId;
            int currentOffset;
            boolean isOffsetSupported;
            block15: {
                Object object2;
                block16: {
                    if (!this.hasNext()) {
                        return new ArrayList<NodeDataIndexing>();
                    }
                    conn = (JDBCStorageConnection)this.connFactory.openConnection();
                    isOffsetSupported = this.connFactory.isOffsetSupported();
                    try {
                        if (!isOffsetSupported) {
                            this.lock.lock();
                        }
                        object2 = this;
                        synchronized (object2) {
                            currentOffset = this.offset.getAndAdd(this.pageSize);
                            currentLastNodeId = this.lastNodeId.get();
                            currentPage = this.page.incrementAndGet();
                        }
                        if (this.hasNext()) break block15;
                        object2 = new ArrayList();
                        Object var12_9 = null;
                        if (isOffsetSupported) break block16;
                        this.lock.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var12_11 = null;
                        if (!isOffsetSupported) {
                            this.lock.unlock();
                        }
                        conn.close();
                        throw throwable;
                    }
                }
                conn.close();
                return object2;
            }
            long time = 0L;
            if (PropertyManager.isDevelopping()) {
                time = System.currentTimeMillis();
            }
            List<NodeDataIndexing> result = conn.getNodesAndProperties(currentLastNodeId, currentOffset, this.pageSize);
            if (PropertyManager.isDevelopping()) {
                LOG.info((Object)("Page = " + currentPage + " Offset = " + currentOffset + " LastNodeId = '" + currentLastNodeId + "', query time = " + (System.currentTimeMillis() - time) + " ms, from '" + (result.isEmpty() ? "unknown" : result.get(0).getIdentifier()) + "' to '" + (result.isEmpty() ? "unknown" : result.get(result.size() - 1).getIdentifier()) + "'"));
            }
            this.hasNext.compareAndSet(true, result.size() == this.pageSize);
            if (this.hasNext() && this.connFactory.isIDNeededForPaging()) {
                object = this;
                synchronized (object) {
                    this.lastNodeId.set(result.get(result.size() - 1).getIdentifier());
                    this.offset.set((this.page.get() - currentPage) * this.pageSize);
                }
            }
            object = result;
            Object var12_10 = null;
            if (isOffsetSupported) break block17;
            this.lock.unlock();
        }
        conn.close();
        return object;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext.get();
    }
}

