/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.net.URI;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.IllegalResourceTypeException;
import org.exoplatform.services.jcr.webdav.resource.VersionHistoryResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedResource;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;

public class VersionedCollectionResource
extends CollectionResource
implements VersionedResource {
    public VersionedCollectionResource(URI identifier, Node node, WebDavNamespaceContext namespaceContext) throws IllegalResourceTypeException, RepositoryException {
        super(6, identifier, node, namespaceContext);
    }

    public VersionHistoryResource getVersionHistory() throws RepositoryException, IllegalResourceTypeException {
        return new VersionHistoryResource(this.versionHistoryURI(), this.node.getVersionHistory(), this, this.namespaceContext);
    }

    protected final URI versionHistoryURI() {
        return URI.create(this.identifier.toASCIIString() + "?vh");
    }

    public HierarchicalProperty getProperty(QName name) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (name.equals(ISVERSIONED)) {
            return new HierarchicalProperty(name, "1");
        }
        if (name.equals(CHECKEDIN)) {
            if (this.node.isCheckedOut()) {
                throw new PathNotFoundException();
            }
            String checkedInHref = this.identifier.toASCIIString() + "?version=" + this.node.getBaseVersion().getName();
            HierarchicalProperty checkedIn = new HierarchicalProperty(name);
            checkedIn.addChild(new HierarchicalProperty(new QName("DAV:", "href"), checkedInHref));
            return checkedIn;
        }
        if (name.equals(CHECKEDOUT)) {
            if (!this.node.isCheckedOut()) {
                throw new PathNotFoundException();
            }
            return new HierarchicalProperty(name);
        }
        if (name.equals(VERSIONNAME)) {
            return new HierarchicalProperty(name, this.node.getBaseVersion().getName());
        }
        return super.getProperty(name);
    }
}

