/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.platform;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.connector.FileUploadHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/managedocument/")
public class ManageDocumentService
implements ResourceContainer {
    protected static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    protected static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private final CacheControl cc;
    private static Log log = ExoLogger.getLogger(ManageDocumentService.class);
    private ManageDriveService manageDriveService;
    protected FileUploadHandler fileUploadHandler;
    public static final String EXO_MUSICFOLDER = "exo:musicFolder";
    public static final String EXO_VIDEOFOLDER = "exo:videoFolder";
    public static final String EXO_PICTUREFOLDER = "exo:pictureFolder";
    public static final String EXO_DOCUMENTFOLDER = "exo:documentFolder";
    public static final String EXO_SEARCHFOLDER = "exo:searchFolder";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String EXO_PRIMARYTYPE = "exo:primaryType";
    public static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    public static final String EXO_FAVOURITE_FOLDER = "exo:favoriteFolder";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FOLDER = "nt:folder";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};

    public ManageDocumentService(ManageDriveService manageDriveService) {
        this.manageDriveService = manageDriveService;
        this.fileUploadHandler = new FileUploadHandler();
        this.cc = new CacheControl();
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @GET
    @Path(value="/getDrives/")
    @RolesAllowed(value={"users"})
    public Response getDrives(@QueryParam(value="driveType") String driveType) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        List<String> userRoles = this.getMemberships();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement("Folders");
        document.appendChild(rootElement);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        Set groups = ConversationState.getCurrent().getIdentity().getGroups();
        List driveList = new ArrayList();
        if (DriveType.GENERAL.toString().equalsIgnoreCase(driveType)) {
            driveList = this.manageDriveService.getMainDrives(userId, userRoles);
        } else if (DriveType.GROUP.toString().equalsIgnoreCase(driveType)) {
            driveList = this.manageDriveService.getGroupDrives(userId, userRoles, new ArrayList(groups));
        } else if (DriveType.PERSONAL.toString().equalsIgnoreCase(driveType)) {
            driveList = this.manageDriveService.getPersonalDrives(userId, userRoles);
        }
        rootElement.appendChild(this.buildXMLDriveNodes(document, driveList, driveType));
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(this.cc).build();
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    @RolesAllowed(value={"users"})
    public Response getFoldersAndFiles(@QueryParam(value="driveName") String driveName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="currentFolder") String currentFolder) {
        try {
            Node node = this.getNode(driveName, workspaceName, currentFolder);
            return this.buildXMLResponseForChildren(node, driveName, currentFolder);
        }
        catch (AccessDeniedException e) {
            log.debug((Object)"Access is denied when perform get Folders and files: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            log.debug((Object)"Item is not found: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            log.error((Object)"Repository is error: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform get Folders and files: ", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/deleteFolderOrFile/")
    @RolesAllowed(value={"users"})
    public Response deleteFolderOrFile(@QueryParam(value="driveName") String driveName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="itemPath") String itemPath) {
        try {
            Node node = this.getNode(driveName, workspaceName, itemPath);
            Node parent = node.getParent();
            node.remove();
            parent.save();
            return Response.ok().cacheControl(this.cc).build();
        }
        catch (AccessDeniedException e) {
            log.debug((Object)"Access is denied when perform delete folder or file: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            log.debug((Object)"Item is not found: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            log.error((Object)"Repository is error: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform delete Folder or file: ", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/createFolder/")
    @RolesAllowed(value={"users"})
    public Response createFolder(@QueryParam(value="driveName") String driveName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="folderName") String folderName) throws Exception {
        try {
            Node node = this.getNode(driveName, workspaceName, currentFolder);
            Node newNode = node.addNode(Text.escapeIllegalJcrChars((String)folderName), NT_UNSTRUCTURED);
            node.save();
            Document document = this.createNewDocument();
            Element folderNode = this.createFolderElement(document, newNode, workspaceName, driveName, currentFolder);
            document.appendChild(folderNode);
            return this.getResponse(document);
        }
        catch (AccessDeniedException e) {
            log.debug((Object)"Access is denied when perform create folder: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (PathNotFoundException e) {
            log.debug((Object)"Item is not found: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (RepositoryException e) {
            log.error((Object)"Repository is error: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform create folder: ", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="/uploadFile/upload/")
    @RolesAllowed(value={"users"})
    public Response uploadFile(@Context HttpServletRequest servletRequest, @QueryParam(value="uploadId") String uploadId) throws Exception {
        return this.fileUploadHandler.upload(servletRequest, uploadId, null);
    }

    @GET
    @Path(value="/uploadFile/control/")
    @RolesAllowed(value={"users"})
    public Response processUpload(@QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="driveName") String driveName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String siteName, @QueryParam(value="action") String action, @QueryParam(value="language") String language, @QueryParam(value="fileName") String fileName, @QueryParam(value="uploadId") String uploadId) throws Exception {
        try {
            if (workspaceName != null && driveName != null && currentFolder != null) {
                Node currentFolderNode = this.getNode(Text.escapeIllegalJcrChars((String)driveName), Text.escapeIllegalJcrChars((String)workspaceName), Text.escapeIllegalJcrChars((String)currentFolder));
                String userId = ConversationState.getCurrent().getIdentity().getUserId();
                return this.createProcessUploadResponse(Text.escapeIllegalJcrChars((String)workspaceName), currentFolderNode, siteName, userId, action, language, Text.escapeIllegalJcrChars((String)fileName), uploadId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when perform processUpload: ", (Throwable)e);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Response buildXMLResponseForChildren(Node node, String driveName, String currentFolder) throws Exception {
        Session session = node.getSession();
        String workspaceName = session.getWorkspace().getName();
        Document document = this.createNewDocument();
        Element rootElement = this.createFolderElement(document, node, workspaceName, driveName, currentFolder);
        Element folders = document.createElement("Folders");
        Element files = document.createElement("Files");
        Node sourceNode = null;
        Node referNode = null;
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable")) continue;
            if (child.isNodeType(EXO_SYMLINK) && child.hasProperty("exo:uuid") && child.hasProperty("exo:workspace")) {
                String sourceWs = child.getProperty("exo:workspace").getString();
                Session sourceSession = this.getSession(sourceWs);
                sourceNode = sourceSession.getNodeByUUID(child.getProperty("exo:uuid").getString());
            }
            Node node2 = referNode = sourceNode != null ? sourceNode : child;
            if (this.isFolder(referNode)) {
                Element folder = this.createFolderElement(document, referNode, referNode.getSession().getWorkspace().getName(), driveName, currentFolder);
                folders.appendChild(folder);
                continue;
            }
            if (!this.isFile(referNode)) continue;
            Element file = this.createFileElement(document, referNode, child, referNode.getSession().getWorkspace().getName());
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        document.appendChild(rootElement);
        return this.getResponse(document);
    }

    private boolean isFolder(Node checkNode) throws RepositoryException {
        return checkNode.isNodeType(NT_FOLDER) || checkNode.isNodeType(NT_UNSTRUCTURED);
    }

    private boolean isFile(Node checkNode) throws RepositoryException {
        return checkNode.isNodeType("nt:file");
    }

    private Element createFolderElement(Document document, Node child, String workspaceName, String driveName, String currentFolder) throws Exception {
        Element folder = document.createElement("Folder");
        boolean hasChild = false;
        boolean canRemove = true;
        boolean canAddChild = true;
        NodeIterator iterator = child.getNodes();
        while (iterator.hasNext()) {
            if (!this.isFolder(iterator.nextNode())) continue;
            hasChild = true;
            break;
        }
        currentFolder = "".equals(currentFolder) ? currentFolder : currentFolder + "/";
        try {
            this.getSession(workspaceName).checkPermission(child.getPath(), "remove");
        }
        catch (Exception e) {
            canRemove = false;
        }
        try {
            this.getSession(workspaceName).checkPermission(child.getPath(), "add_node");
        }
        catch (Exception e) {
            canAddChild = false;
        }
        folder.setAttribute("name", child.getName());
        folder.setAttribute("path", child.getPath());
        folder.setAttribute("canRemove", String.valueOf(canRemove));
        folder.setAttribute("canAddChild", String.valueOf(canAddChild));
        folder.setAttribute("nodeType", ManageDocumentService.getNodeTypeIcon(child));
        folder.setAttribute("workspaceName", workspaceName);
        folder.setAttribute("driveName", driveName);
        folder.setAttribute("currentFolder", currentFolder + child.getName());
        folder.setAttribute("hasChild", String.valueOf(hasChild));
        return folder;
    }

    private Element createFileElement(Document document, Node sourceNode, Node displayNode, String workspaceName) throws Exception {
        Element file = document.createElement("File");
        boolean canRemove = true;
        file.setAttribute("name", displayNode.getName());
        file.setAttribute("workspaceName", workspaceName);
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3);
        file.setAttribute("dateCreated", formatter.format(sourceNode.getProperty("exo:dateCreated").getDate().getTime()));
        if (sourceNode.hasProperty("exo:dateModified")) {
            file.setAttribute("dateModified", formatter.format(sourceNode.getProperty("exo:dateModified").getDate().getTime()));
        } else {
            file.setAttribute("dateModified", null);
        }
        file.setAttribute("creator", sourceNode.getProperty("exo:owner").getString());
        file.setAttribute("path", displayNode.getPath());
        if (sourceNode.isNodeType("nt:file")) {
            Node content = sourceNode.getNode("jcr:content");
            file.setAttribute("nodeType", content.getProperty("jcr:mimeType").getString());
        } else {
            file.setAttribute("nodeType", sourceNode.getPrimaryNodeType().getName());
        }
        long size = sourceNode.getNode("jcr:content").getProperty("jcr:data").getLength();
        file.setAttribute("size", "" + size);
        try {
            this.getSession(workspaceName).checkPermission(sourceNode.getPath(), "remove");
        }
        catch (Exception e) {
            canRemove = false;
        }
        file.setAttribute("canRemove", String.valueOf(canRemove));
        return file;
    }

    private Node getNode(String driveName, String workspaceName, String currentFolder) throws Exception {
        Session session = this.getSession(workspaceName);
        String driveHomePath = this.manageDriveService.getDriveByName(Text.escapeIllegalJcrChars((String)driveName)).getHomePath();
        String itemPath = driveHomePath + (currentFolder != null && !"".equals(currentFolder) && !driveHomePath.endsWith("/") ? "/" : "") + currentFolder;
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        itemPath = Utils.getPersonalDrivePath((String)itemPath, (String)userId);
        return (Node)session.getItem(Text.escapeIllegalJcrChars((String)itemPath));
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ManageableRepository manageableRepository = this.getCurrentRepository();
        return sessionProvider.getSession(workspaceName, manageableRepository);
    }

    private Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    private ManageableRepository getCurrentRepository() throws RepositoryException {
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    private Response getResponse(Document document) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(this.cc).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Element buildXMLDriveNodes(Document document, List<DriveData> drivesList, String driveType) throws Exception {
        Element folders = document.createElement("Folders");
        folders.setAttribute("name", driveType);
        for (DriveData drive : drivesList) {
            Element folder = document.createElement("Folder");
            folder.setAttribute("name", drive.getName());
            folder.setAttribute("nodeType", driveType + " " + drive.getName().replaceAll(" ", "_"));
            folder.setAttribute("workspaceName", drive.getWorkspace());
            folder.setAttribute("canAddChild", drive.getAllowCreateFolders());
            folders.appendChild(folder);
        }
        return folders;
    }

    private List<String> getMemberships() throws Exception {
        ArrayList<String> userMemberships = new ArrayList<String>();
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        userMemberships.add(userId);
        Collection memberships = ConversationState.getCurrent().getIdentity().getMemberships();
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            MembershipEntry membership = (MembershipEntry)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroup();
            userMemberships.add(role);
        }
        return userMemberships;
    }

    public static String getNodeTypeIcon(Node node) throws RepositoryException {
        StringBuilder str = new StringBuilder();
        if (node == null) {
            return "";
        }
        String nodeType = node.getPrimaryNodeType().getName();
        if (node.isNodeType(EXO_SYMLINK)) {
            LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
            try {
                nodeType = node.getProperty(EXO_PRIMARYTYPE).getString();
                node = linkManager.getTarget(node);
                if (node == null) {
                    return "";
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        if (node.isNodeType(EXO_TRASH_FOLDER)) {
            nodeType = EXO_TRASH_FOLDER;
        }
        if (node.isNodeType(EXO_FAVOURITE_FOLDER)) {
            nodeType = EXO_FAVOURITE_FOLDER;
        }
        if (nodeType.equals(NT_UNSTRUCTURED) || nodeType.equals(NT_FOLDER)) {
            for (String specificFolder : SPECIFIC_FOLDERS) {
                if (!node.isNodeType(specificFolder)) continue;
                nodeType = specificFolder;
                break;
            }
        }
        str.append(nodeType);
        return str.toString();
    }

    protected Response createProcessUploadResponse(String workspaceName, Node currentFolderNode, String siteName, String userId, String action, String language, String fileName, String uploadId) throws Exception {
        if ("save".equals(action)) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return this.fileUploadHandler.saveAsNTFile(currentFolderNode, uploadId, fileName, language, siteName, userId);
        }
        return this.fileUploadHandler.control(uploadId, action);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DriveType {
        GENERAL,
        GROUP,
        PERSONAL;

    }
}

