/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.form;

import java.util.Collection;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormRichtextInput
extends UIFormInputBase<String> {
    public static final String FULL_TOOLBAR = "Full";
    public static final String BASIC_TOOLBAR = "Basic";
    private String width;
    private String height;
    private String toolbar;

    public UIFormRichtextInput(String name, String bindingField, String value) {
        super(name, bindingField, String.class);
        this.value_ = value;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.toolbar == null) {
            this.toolbar = BASIC_TOOLBAR;
        }
        if (this.width == null) {
            this.width = "'100%'";
        }
        if (this.height == null) {
            this.height = "200";
        }
        StringBuffer contentsCss = new StringBuffer();
        contentsCss.append("[");
        SkinService skinService = (SkinService)WCMCoreUtils.getService(SkinService.class);
        String skin = Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin();
        String portal = Util.getUIPortal().getName();
        Collection portalSkins = skinService.getPortalSkins(skin);
        SkinConfig customSkin = skinService.getSkin(portal, Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin());
        if (customSkin != null) {
            portalSkins.add(customSkin);
        }
        for (SkinConfig portalSkin : portalSkins) {
            contentsCss.append("'").append(portalSkin.createURL()).append("',");
        }
        contentsCss.delete(contentsCss.length() - 1, contentsCss.length());
        contentsCss.append("]");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div>");
        buffer.append("<span style='float:left; width:98%;'>");
        if (this.value_ != null) {
            buffer.append("<textarea id='" + this.name + "' name='" + this.name + "'>" + (String)this.value_ + "</textarea>\n");
        } else {
            buffer.append("<textarea id='" + this.name + "' name='" + this.name + "'></textarea>\n");
        }
        buffer.append("<script type='text/javascript'>\n");
        buffer.append("  //<![CDATA[\n");
        buffer.append("    var instances = CKEDITOR.instances['" + this.name + "']; if (instances) instances.destroy(true);\n");
        buffer.append("    CKEDITOR.replace('" + this.name + "', {toolbar:'" + this.toolbar + "', height:" + this.height + ", contentsCss:" + contentsCss + "});\n");
        buffer.append("  //]]>\n");
        buffer.append("</script>\n");
        buffer.append("</span>");
        if (this.isMandatory()) {
            buffer.append("<span style='float:left'> &nbsp;*</span>");
        }
        buffer.append("</div>");
        context.getWriter().write(buffer.toString());
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }
}

