/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String WORKSPACE_NAME = "workspace";
    public static final String JCR_PATH = "path";
    public static final String DRIVE_FOLDER = "allowCreateFolder";
    public static final String MIN_WIDTH = "minwidth";
    public static final String CB_DOCUMENT_NAME = "documentName";
    public static final String CB_SCRIPT_NAME = "scriptName";
    public static final String CB_REF_DOCUMENT = "reference";
    public static final String CB_CHILD_DOCUMENT = "child";
    public static final String CB_NB_PER_PAGE = "nbPerPage";
    public static final String CB_QUERY_STATEMENT = "queryStatement";
    public static final String CB_QUERY_ISNEW = "isAddNew";
    public static final String CB_QUERY_TYPE = "queryType";
    public static final String CB_QUERY_STORE = "queryStore";
    public static final String CB_QUERY_LANGUAGE = "queryLanguage";
    public static final String CB_VIEW_TOOLBAR = "viewToolbar";
    public static final String CB_VIEW_TAGMAP = "viewTagMap";
    public static final String CB_VIEW_COMMENT = "viewComment";
    public static final String CB_VIEW_VOTE = "viewVote";
    public static final String CB_SEARCH_LOCATION = "searchLocation";
    public static final String CB_ENABLE_SEARCH_LOCATION = "enableSearch";
    public static final String CB_FILTER_CATEGORY = "filterCategory";
    public static final String EXO_AUDITABLE = "exo:auditable";
    public static final String CB_BOX_TEMPLATE = "boxTemplate";
    public static final String CB_TEMPLATE = "template";
    public static final String CB_USECASE = "usecase";
    public static final String CB_ALLOW_PUBLISH = "isAllowPublish";
    public static final String FROM_PATH = "From Path";
    public static final String USE_DOCUMENT = "Document";
    public static final String USE_JCR_QUERY = "Using a JCR query";
    public static final String USE_SCRIPT = "Using a script";
    public static final String CB_USE_FROM_PATH = "path";
    public static final String CB_USE_DOCUMENT = "detail-document";
    public static final String CB_USE_JCR_QUERY = "query";
    public static final String CB_USE_SCRIPT = "script";
    public static final String SEMI_COLON = ";";
    public static final String COLON = ":";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EXO_CREATED_DATE = "exo:dateCreated";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFIED_DATE = "exo:dateModified";
    public static final String EXO_OWNER = "exo:owner";
    public static final String[] SPECIALCHARACTER = new String[]{";", ":", "/", "\\", "'", "|", ">", "<", "\"", "?", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "[", "]", "{", "}"};
    public static final String REPOSITORY = "repository";
    public static final String VIEWS = "views";
    public static final String DRIVE = "drive";
    public static final String TRASH_HOME_NODE_PATH = "trashHomeNodePath";
    public static final String TRASH_REPOSITORY = "trashRepository";
    public static final String TRASH_WORKSPACE = "trashWorkspace";
    public static final String JCR_INFO = "jcrInfo";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FILE = "nt:file";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FROZEN = "nt:frozenNode";
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_RELATION = "exo:relation";
    @Deprecated
    public static final String EXO_TAXANOMY = "exo:taxonomy";
    public static final String EXO_TAXONOMY = "exo:taxonomy";
    public static final String EXO_IMAGE = "exo:image";
    public static final String EXO_ARTICLE = "exo:article";
    public static final String EXO_LANGUAGE = "exo:language";
    public static final String LANGUAGES = "languages";
    public static final String EXO_METADATA = "exo:metadata";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_BASE = "nt:base";
    public static final String DEFAULT = "default";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_FROZEN = "jcr:frozenNode";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_SCORE = "jcr:score";
    public static final String EXO_ROLES = "exo:roles";
    public static final String EXO_TEMPLATEFILE = "exo:templateFile";
    public static final String EXO_TEMPLATE = "exo:template";
    public static final String EXO_ACTION = "exo:action";
    public static final String EXO_ACTIONS = "exo:actions";
    public static final String MIX_LOCKABLE = "mix:lockable";
    public static final String EXO_CATEGORIZED = "exo:categorized";
    public static final String EXO_CATEGORY = "exo:category";
    public static final String EXO_HIDDENABLE = "exo:hiddenable";
    public static final String EXO_ACCESSPERMISSION = "exo:accessPermissions";
    public static final String EXO_PERMISSIONS = "exo:permissions";
    public static final String EXO_FAVOURITE = "exo:favourite";
    public static final String EXO_FAVOURITE_FOLDER = "exo:favoriteFolder";
    public static final String EXO_FAVOURITER = "exo:favouriter";
    public static final String EXO_RESTOREPATH = "exo:restorePath";
    public static final String EXO_RESTORELOCATION = "exo:restoreLocation";
    public static final String EXO_RESTORE_WORKSPACE = "exo:restoreWorkspace";
    public static final String EXO_LASTMODIFIER = "exo:lastModifier";
    public static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    public static final String EXO_TOTAL = "exo:total";
    public static final String EXO_WEBCONTENT = "exo:webContent";
    public static final String EXO_RSS_ENABLE = "exo:rss-enable";
    public static final String EXO_MUSICFOLDER = "exo:musicFolder";
    public static final String EXO_VIDEOFOLDER = "exo:videoFolder";
    public static final String EXO_PICTUREFOLDER = "exo:pictureFolder";
    public static final String EXO_DOCUMENTFOLDER = "exo:documentFolder";
    public static final String EXO_SEARCHFOLDER = "exo:searchFolder";
    public static final String MIX_COMMENTABLE = "mix:commentable";
    public static final String MIX_VOTABLE = "mix:votable";
    public static final String RMA_RECORD = "rma:record";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String EXO_PRIMARYTYPE = "exo:primaryType";
    public static final String EXO_SORTABLE = "exo:sortable";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};
    public static final String[] FOLDERS = new String[]{"nt:unstructured", "nt:folder"};
    public static final String[] NON_EDITABLE_NODETYPES = new String[]{"nt:unstructured", "nt:folder", "nt:resource"};
    public static final String[] CATEGORY_NODE_TYPES = new String[]{"nt:folder", "nt:unstructured", "exo:taxonomy"};
    public static final String CATEGORY_MANDATORY = "categoryMandatoryWhenFileUpload";
    public static final String UPLOAD_SIZE_LIMIT_MB = "uploadFileSizeLimitMB";
    public static final String FILE_VIEWER_EXTENSION_TYPE = "org.exoplatform.ecm.dms.FileViewer";
    public static final String MIME_TYPE = "mimeType";
    public static final String LOCALE_WEBUI_DMS = "locale.portlet.i18n.WebUIDms";
    public static final String REQUESTCONTEXT = "requestcontext";
    public static final String WORKSPACE_PARAM = "workspaceName";
    public static final String EMPTY = "";
    public static final String PUBLIC = "Public";
    public static final String GROUP = "Group";
    public static final String SITE = "Site";
    public static final String PRIVATE = "Private";
    public static final String URL_BACKTO = "backto";
    private static final Log LOG = ExoLogger.getLogger((String)"webui.Utils");
    public Map<String, Object> maps_ = new HashMap<String, Object>();
    public static final String INPUT_TEXT_AREA = "TEXTAREA";
    public static final String INPUT_WYSIWYG = "WYSIWYG";
    public static final String INPUT_TEXT = "TEXT";
    public static final String DEFAULT_CSS_NAME = "InlineText";
    public static final String LEFT2RIGHT = "left-to-right";
    public static final String RIGHT2LEFT = "right-to-left";
    protected static final String SEPARATOR = "=";
    protected static final String TOOLBAR = "toolbar";
    protected static final String CSS = "CSSData";
    protected static final String HEIGHT = "height";
    protected static final String BUTTON_DIR = "button_direction";
    protected static final String PREV_HTML = "prev_html";
    protected static final String POST_HTML = "post_html";

    public static String encodeHTML(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String formatNodeName(String text) {
        return text.replaceAll("'", "\\\\'");
    }

    public static boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType(MIX_VERSIONABLE);
    }

    public static boolean isTrashHomeNode(Node node) throws RepositoryException {
        return node.isNodeType(EXO_TRASH_FOLDER);
    }

    public static boolean isInTrash(Node node) throws RepositoryException {
        TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
        return trashService.isInTrash(node);
    }

    public static boolean isReferenceable(Node node) throws RepositoryException {
        return node.isNodeType(MIX_REFERENCEABLE);
    }

    public static boolean isNameValid(String name, String[] regexpression) {
        for (String c : regexpression) {
            if (!name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameEmpty(String name) {
        return name == null || name.trim().length() == 0;
    }

    public static boolean isAuditable(Node node) throws RepositoryException {
        return node.isNodeType(EXO_AUDITABLE);
    }

    public static String getIndexName(Node node) throws RepositoryException {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(node.getName());
        int index = node.getIndex();
        if (index > 1) {
            buffer.append('[');
            buffer.append(index);
            buffer.append(']');
        }
        return buffer.toString();
    }

    @Deprecated
    public static List<String> getListAllowedFileType(Node currentNode, String repository, TemplateService templateService) throws Exception {
        return Utils.getListAllowedFileType(currentNode, templateService);
    }

    public static List<String> getListAllowedFileType(Node currentNode, TemplateService templateService) throws Exception {
        ArrayList<String> nodeTypes = new ArrayList<String>();
        NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
        NodeType currentNodeType = currentNode.getPrimaryNodeType();
        NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
        List templates = templateService.getDocumentTemplates();
        try {
            block2: for (int i = 0; i < templates.size(); ++i) {
                String nodeTypeName = ((String)templates.get(i)).toString();
                NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                NodeType[] superTypes = nodeType.getSupertypes();
                boolean isCanCreateDocument = false;
                for (NodeDefinition nodeDefinition : childDefs) {
                    NodeType[] requiredChilds;
                    for (NodeType requiredChild : requiredChilds = nodeDefinition.getRequiredPrimaryTypes()) {
                        if (!nodeTypeName.equals(requiredChild.getName())) continue;
                        isCanCreateDocument = true;
                        break;
                    }
                    if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                    if (!nodeTypes.contains(nodeTypeName)) {
                        nodeTypes.add(nodeTypeName);
                    }
                    isCanCreateDocument = true;
                }
                if (isCanCreateDocument) continue;
                for (NodeDefinition nodeDefinition : superTypes) {
                    for (NodeDefinition childDef : childDefs) {
                        for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                            if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                            if (!nodeTypes.contains(nodeTypeName)) {
                                nodeTypes.add(nodeTypeName);
                            }
                            isCanCreateDocument = true;
                            break;
                        }
                        if (isCanCreateDocument) break;
                    }
                    if (isCanCreateDocument) continue block2;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return nodeTypes;
    }

    public static String getNodeTypeIcon(Node node, String appended, String mode) throws RepositoryException {
        StringBuilder str = new StringBuilder();
        if (node == null) {
            return EMPTY;
        }
        String nodeType = node.getPrimaryNodeType().getName();
        if (node.isNodeType(EXO_SYMLINK)) {
            LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
            try {
                nodeType = node.getProperty(EXO_PRIMARYTYPE).getString();
                node = linkManager.getTarget(node);
                if (node == null) {
                    return EMPTY;
                }
            }
            catch (Exception e) {
                return EMPTY;
            }
        }
        if (node.isNodeType(EXO_TRASH_FOLDER)) {
            nodeType = EXO_TRASH_FOLDER;
        }
        if (node.isNodeType(EXO_FAVOURITE_FOLDER)) {
            nodeType = EXO_FAVOURITE_FOLDER;
        }
        if (nodeType.equals(NT_UNSTRUCTURED) || nodeType.equals(NT_FOLDER)) {
            for (String specificFolder : SPECIFIC_FOLDERS) {
                if (!node.isNodeType(specificFolder)) continue;
                nodeType = specificFolder;
                break;
            }
        }
        nodeType = nodeType.replace(':', '_') + appended;
        str.append(nodeType);
        str.append(" ");
        str.append("default16x16Icon");
        if (mode != null && mode.equalsIgnoreCase("Collapse")) {
            str.append(' ').append(mode).append(nodeType);
        }
        if (node.isNodeType(NT_FILE) && node.hasNode(JCR_CONTENT)) {
            Node jcrContentNode = node.getNode(JCR_CONTENT);
            str.append(' ').append(jcrContentNode.getProperty(JCR_MIMETYPE).getString().replaceAll("/|\\.", "_")).append(appended);
        }
        return str.toString();
    }

    public static String getNodeTypeIcon(Node node, String appended) throws RepositoryException {
        return Utils.getNodeTypeIcon(node, appended, null);
    }

    public static NodeIterator getAuthorizedChildNodes(Node node) throws Exception {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            if (PermissionUtil.canRead(iter.nextNode())) continue;
            iter.remove();
        }
        return iter;
    }

    public static List<Node> getAuthorizedChildList(Node node) throws Exception {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!PermissionUtil.canRead(child)) continue;
            children.add(child);
        }
        return children;
    }

    public static boolean isLockTokenHolder(Node node) throws Exception {
        return node.getLock().getLockToken() != null;
    }

    public static List<String> getMemberships() throws Exception {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection<MembershipEntry> memberships = Utils.getUserMembershipsFromIdentityRegistry(userId);
        if (memberships != null) {
            for (MembershipEntry membership : memberships) {
                String role = membership.getMembershipType() + COLON + membership.getGroup();
                userMemberships.add(role);
            }
        }
        return userMemberships;
    }

    private static Collection<MembershipEntry> getUserMembershipsFromIdentityRegistry(String authenticatedUser) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        Identity currentUserIdentity = identityRegistry.getIdentity(authenticatedUser);
        return currentUserIdentity.getMemberships();
    }

    public static List<String> getGroups() throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity identity = conversationState.getIdentity();
        Set groups = identity.getGroups();
        return new ArrayList<String>(groups);
    }

    public static String getNodeOwner(Node node) throws Exception {
        try {
            if (node.hasProperty(EXO_OWNER)) {
                return node.getProperty(EXO_OWNER).getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public static Node findNodeByUUID(String repository, String uuid) throws Exception {
        return Utils.findNodeByUUID(uuid);
    }

    public static Node findNodeByUUID(String uuid) throws Exception {
        RepositoryService repositoryService = (RepositoryService)Util.getUIPortal().getApplicationComponent(RepositoryService.class);
        SessionProviderService sessionProviderService = (SessionProviderService)Util.getUIPortal().getApplicationComponent(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Node node = null;
        for (String wsName : manageableRepository.getWorkspaceNames()) {
            try {
                node = sessionProvider.getSession(wsName, manageableRepository).getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return node;
    }

    public static boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public static Node getNodeSymLink(Node node) throws Exception {
        LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
        Node realNode = null;
        if (linkManager.isLink((Item)node)) {
            if (linkManager.isTargetReachable(node)) {
                realNode = linkManager.getTarget(node);
            }
        } else {
            realNode = node;
        }
        return realNode;
    }

    public static InputStream extractFirstEntryFromZipFile(ZipInputStream zipStream) throws Exception {
        return zipStream.getNextEntry() == null ? null : zipStream;
    }

    public static String getThumbnailImage(Node node, String propertyName) throws Exception {
        Node thumbnailNode;
        String mimeType;
        ThumbnailService thumbnailService = (ThumbnailService)Util.getUIPortal().getApplicationComponent(ThumbnailService.class);
        if (node.getPrimaryNodeType().getName().equals(NT_FILE) && (mimeType = node.getNode(JCR_CONTENT).getProperty(JCR_MIMETYPE).getString()).startsWith("image")) {
            Node thumbnailNode2 = thumbnailService.addThumbnailNode(node);
            InputStream inputStream = node.getNode(JCR_CONTENT).getProperty(JCR_DATA).getStream();
            thumbnailService.createSpecifiedThumbnail(thumbnailNode2, ImageIO.read(inputStream), propertyName);
        }
        if ((thumbnailNode = thumbnailService.getThumbnailNode(node)) != null && thumbnailNode.hasProperty(propertyName)) {
            DownloadService dservice = (DownloadService)Util.getUIPortal().getApplicationComponent(DownloadService.class);
            InputStream input = thumbnailNode.getProperty(propertyName).getStream();
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
            dresource.setDownloadName(node.getName());
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public static String calculateFileSize(double fileLengthLong) {
        int fileLengthDigitCount = Double.toString(fileLengthLong).length();
        double fileSizeKB = 0.0;
        String howBig = EMPTY;
        if (fileLengthDigitCount < 5) {
            fileSizeKB = Math.abs(fileLengthLong);
            howBig = "Byte(s)";
        } else if (fileLengthDigitCount >= 5 && fileLengthDigitCount <= 6) {
            fileSizeKB = Math.abs(fileLengthLong / 1024.0);
            howBig = "KB";
        } else if (fileLengthDigitCount >= 7 && fileLengthDigitCount <= 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1048576.0);
            howBig = "MB";
        } else if (fileLengthDigitCount > 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1.073741824E9);
            howBig = "GB";
        }
        String finalResult = Utils.roundTwoDecimals(fileSizeKB);
        return finalResult + " " + howBig;
    }

    private static String roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return twoDForm.format(d);
    }

    public static String getResourceBundle(String key) throws MissingResourceException {
        PortalRequestContext context = Util.getPortalRequestContext();
        ResourceBundle res = context.getApplicationResourceBundle();
        return res.getString(key);
    }

    public static String getResourceBundle(String name, String key, ClassLoader cl) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(name, locale, cl);
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public static String getRestContextName(String portalContainerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        return portalContainerConfig.getRestContextName(portalContainerName);
    }

    public static String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        String defaultValue = EMPTY;
        String idGenerator = EMPTY;
        Pattern p = Pattern.compile("[^a-zA-Z0-9]");
        Matcher m = p.matcher(propertyName);
        if (orgNode.hasProperty(propertyName)) {
            defaultValue = orgNode.getProperty(propertyName).getString();
        }
        idGenerator = m.replaceAll("_");
        return Utils.getInlineEditingField(orgNode, propertyName, defaultValue, INPUT_TEXT, idGenerator, DEFAULT_CSS_NAME, true, new String[0]);
    }

    public static String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        HashMap<String, String> parsedArguments = Utils.parseArguments(arguments);
        String height = parsedArguments.get(HEIGHT);
        String bDirection = parsedArguments.get(BUTTON_DIR);
        if (org.exoplatform.wcm.webui.Utils.getCurrentMode().equals("Live")) {
            if (orgNode.hasProperty(propertyName)) {
                try {
                    return orgNode.getProperty(propertyName).getString();
                }
                catch (Exception e) {
                    return defaultValue;
                }
            }
            return defaultValue;
        }
        String currentValue = defaultValue;
        if (orgNode.hasProperty(propertyName)) {
            try {
                currentValue = orgNode.getProperty(propertyName).getString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Locale locale = WebuiRequestContext.getCurrentInstance().getLocale();
        String language = locale.getLanguage();
        ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(LOCALE_WEBUI_DMS, locale);
        String portletRealID = org.exoplatform.wcm.webui.Utils.getRealPortletId((PortletRequestContext)WebuiRequestContext.getCurrentInstance());
        StringBuffer sb = new StringBuffer();
        StringBuffer actionsb = new StringBuffer();
        String repo = ((ManageableRepository)orgNode.getSession().getRepository()).getConfiguration().getName();
        String workspace = orgNode.getSession().getWorkspace().getName();
        String uuid = orgNode.getUUID();
        String strSuggestion = EMPTY;
        portletRealID = portletRealID.replace('-', '_');
        String showBlockId = "Current" + idGenerator + "_" + portletRealID;
        String editBlockEditorID = "Edit" + idGenerator + "_" + portletRealID;
        String editFormID = "Edit" + idGenerator + "Form_" + portletRealID;
        String newValueInputId = "new" + idGenerator + "_" + portletRealID;
        String currentValueID = "old" + idGenerator + "_" + portletRealID;
        String siteName = Util.getPortalRequestContext().getPortalOwner();
        try {
            strSuggestion = resourceBundle.getString("UIPresentation.label.EditingSuggestion");
        }
        catch (Exception E) {
            // empty catch block
        }
        actionsb.append(" return InlineEditor.presentationRequestChange");
        if (isGenericProperty) {
            actionsb.append("Property").append("('").append("/property?', '").append(propertyName).append("', '");
        } else {
            actionsb.append(cssClass).append("('");
        }
        actionsb.append(currentValueID).append("', '").append(newValueInputId).append("', '").append(repo).append("', '").append(workspace).append("', '").append(uuid).append("', '").append(editBlockEditorID).append("', '").append(showBlockId).append("', '").append(siteName).append("', '").append(language);
        if (inputType.equals(INPUT_WYSIWYG)) {
            actionsb.append("', 1);");
        } else {
            actionsb.append("');");
        }
        String strAction = actionsb.toString();
        sb.append("<div class=\"InlineEditing\">\n");
        sb.append("\n<div id=\"").append(showBlockId).append("\" Class=\"").append(cssClass).append("\"");
        sb.append("title=\"").append(strSuggestion).append("\"");
        sb.append(" onDblClick=\"InlineEditor.presentationSwitchBlock('").append(showBlockId).append("', '").append(editBlockEditorID).append("');\"");
        sb.append("onmouseout=\"this.className='").append(cssClass).append("';\" onblur=\"this.className='").append(cssClass).append("';\" onfocus=\"this.className='").append(cssClass).append("Hover").append("';\" onmouseover=\"this.className='").append(cssClass).append("Hover';\">").append(currentValue).append("</div>\n");
        sb.append("\t<div id=\"").append(editBlockEditorID).append("\" class=\"Edit").append(cssClass).append("\">\n");
        sb.append("\t\t<form name=\"").append(editFormID).append("\" id=\"").append(editFormID).append("\" onSubmit=\"").append(strAction).append("\">\n");
        sb.append("<DIV style=\"display:none; visible:hidden\" id=\"").append(currentValueID).append("\" name=\"").append(currentValueID).append("\">").append(currentValue).append("</DIV>");
        if (bDirection != null && bDirection.equals(LEFT2RIGHT)) {
            sb.append("\t\t<a href=\"#\" class =\"AcceptButton\" style=\"float:left\" onclick=\"").append(strAction).append("\">&nbsp;</a>\n");
            sb.append("\t\t<a href=\"#\" class =\"CancelButton\" style=\"float:left\" ").append("onClick=\"InlineEditor.presentationSwitchBlock('");
            sb.append(editBlockEditorID).append("', '").append(showBlockId).append("');\">&nbsp;</a>\n");
        } else {
            sb.append("\t\t<a href=\"#\" class =\"CancelButton\" ").append("onClick=\"InlineEditor.presentationSwitchBlock('");
            sb.append(editBlockEditorID).append("', '").append(showBlockId).append("');\">&nbsp;</a>\n");
            sb.append("\t\t<a href=\"#\" class =\"AcceptButton\" onclick=\"").append(strAction).append("\">&nbsp;</a>\n");
        }
        sb.append("\t\t<div class=\"Edit").append(cssClass).append("Input\">\n ");
        if (inputType.equalsIgnoreCase(INPUT_WYSIWYG)) {
            sb.append(Utils.createCKEditorField(newValueInputId, currentValue, parsedArguments));
        } else if (inputType.equalsIgnoreCase(INPUT_TEXT_AREA)) {
            sb.append("\t\t<TEXTAREA ").append("\" name =\"");
            sb.append(newValueInputId).append("\" id =\"").append(newValueInputId).append("\"");
            if (height != null && height.length() > 0) {
                sb.append(" style =\"height:").append(height);
                if (!height.endsWith("px")) {
                    sb.append("px;");
                }
                sb.append("\"");
            }
            sb.append(">");
            sb.append(currentValue).append("</TEXTAREA>");
        } else if (inputType.equalsIgnoreCase(INPUT_TEXT)) {
            sb.append("\t\t<input type=\"TEXT\" name =\"");
            sb.append(newValueInputId).append("\" id =\"").append(newValueInputId).append("\" value=\"").append(currentValue).append("\"/>");
        }
        sb.append("\n\t\t</div>\n\t</form>\n</div>\n\n</div>");
        return sb.toString();
    }

    private static String createCKEditorField(String name, String value_, HashMap<String, String> arguments) {
        String toolbar = arguments.get(TOOLBAR);
        String passedCSS = arguments.get(CSS);
        if (toolbar == null) {
            toolbar = "BasicWCM";
        }
        StringBuffer contentsCss = new StringBuffer();
        contentsCss.append("[");
        SkinService skinService = (SkinService)WCMCoreUtils.getService(SkinService.class);
        String skin = Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin();
        String portal = Util.getUIPortal().getName();
        Collection portalSkins = skinService.getPortalSkins(skin);
        SkinConfig customSkin = skinService.getSkin(portal, Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin());
        if (customSkin != null) {
            portalSkins.add(customSkin);
        }
        for (SkinConfig portalSkin : portalSkins) {
            contentsCss.append("'").append(portalSkin.createURL()).append("',");
        }
        contentsCss.delete(contentsCss.length() - 1, contentsCss.length());
        contentsCss.append("]");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div style=\"display:none\"><textarea id='cssContent" + name + "' name='cssContent" + name + "'>" + passedCSS + "</textarea></div>\n");
        if (value_ != null) {
            buffer.append("<textarea id='" + name + "' name='" + name + "'>" + value_ + "</textarea>\n");
        } else {
            buffer.append("<textarea id='" + name + "' name='" + name + "'></textarea>\n");
        }
        buffer.append("<script type='text/javascript'>\n");
        buffer.append("  //<![CDATA[ \n");
        buffer.append("    var instances = CKEDITOR.instances['" + name + "']; if (instances) instances.destroy(true);\n");
        buffer.append("    CKEDITOR.replace('" + name + "', {toolbar:'" + toolbar + "', width:'98%', height: 200, contentsCss:" + contentsCss + ", ignoreEmptyParagraph:true});\n");
        buffer.append("    CKEDITOR.instances['" + name + "'].on(\"instanceReady\", function(){  ");
        buffer.append("       eXo.ecm.CKEditor.insertCSS('" + name + "', 'cssContent" + name + "');\n");
        buffer.append("       });");
        buffer.append("  //]]> \n");
        buffer.append("</script>\n");
        return buffer.toString();
    }

    private static HashMap<String, String> parseArguments(String ... arguments) {
        HashMap<String, String> map = new HashMap<String, String>();
        int sIndex = -1;
        for (String argument : arguments) {
            String value = null;
            sIndex = argument.indexOf(SEPARATOR);
            if (sIndex <= 0) continue;
            value = argument.substring(sIndex + 1);
            if (argument.startsWith("path")) {
                map.put("path", value);
                continue;
            }
            if (argument.startsWith(TOOLBAR)) {
                map.put(TOOLBAR, value);
                continue;
            }
            if (argument.startsWith(CSS)) {
                map.put(CSS, value);
                continue;
            }
            if (argument.startsWith(HEIGHT)) {
                map.put(HEIGHT, value);
                continue;
            }
            if (argument.startsWith(BUTTON_DIR)) {
                map.put(BUTTON_DIR, value);
                continue;
            }
            if (argument.startsWith(PREV_HTML)) {
                map.put(PREV_HTML, value);
                continue;
            }
            if (!argument.startsWith(POST_HTML)) continue;
            map.put(POST_HTML, value);
        }
        return map;
    }

    public static String getTitleWithSymlink(Node node) throws Exception {
        Node content;
        String title = null;
        Node nProcessNode = node;
        if (title == null) {
            nProcessNode = node;
            if (nProcessNode.hasProperty(EXO_TITLE)) {
                title = nProcessNode.getProperty(EXO_TITLE).getValue().getString();
            }
            if (nProcessNode.hasNode(JCR_CONTENT) && (content = nProcessNode.getNode(JCR_CONTENT)).hasProperty("dc:title")) {
                try {
                    title = content.getProperty("dc:title").getValues()[0].getString();
                }
                catch (Exception e) {
                    title = null;
                }
            }
            if (title != null) {
                title = title.trim();
            }
        }
        if (title != null && title.length() > 0) {
            return Text.unescapeIllegalJcrChars((String)title);
        }
        if (Utils.isSymLink(node)) {
            if ((nProcessNode = Utils.getNodeSymLink(nProcessNode)) == null) {
                nProcessNode = node;
            }
            if (nProcessNode.hasProperty(EXO_TITLE)) {
                title = nProcessNode.getProperty(EXO_TITLE).getValue().getString();
            }
            if (nProcessNode.hasNode(JCR_CONTENT) && (content = nProcessNode.getNode(JCR_CONTENT)).hasProperty("dc:title")) {
                try {
                    title = content.getProperty("dc:title").getValues()[0].getString();
                }
                catch (Exception e) {
                    title = null;
                }
            }
            if (title != null && (title = title.trim()).length() == 0) {
                title = null;
            }
        }
        if (title == null) {
            title = nProcessNode.getName();
        }
        return Text.unescapeIllegalJcrChars((String)title);
    }

    public static UIComponent getUIComponent(String mimeType, UIContainer container) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)WCMCoreUtils.getService(UIExtensionManager.class);
        List extensions = manager.getUIExtensions(FILE_VIEWER_EXTENSION_TYPE);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(MIME_TYPE, mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, container);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeTypeNameComparator
    implements Comparator<NodeType> {
        @Override
        public int compare(NodeType n1, NodeType n2) throws ClassCastException {
            String name1 = n1.getName();
            String name2 = n2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

