/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.thumbnail;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/thumbnail/UIThumbnailForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveThumbnailActionListener.class}, confirm="UIThumbnailForm.msg.confirm-delete", phase=Event.Phase.DECODE)})
public class UIThumbnailForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIJCRExplorer");
    public static final String THUMBNAIL_FIELD = "mediumSize";
    private boolean thumbnailRemoved_ = false;

    public UIThumbnailForm() throws Exception {
        this.setMultiPart(true);
        UIFormUploadInput uiInput = new UIFormUploadInput(THUMBNAIL_FIELD, THUMBNAIL_FIELD);
        uiInput.setAutoUpload(true);
        this.addUIFormInput((UIFormInput)uiInput);
    }

    public String getThumbnailImage(Node node) throws Exception {
        return Utils.getThumbnailImage((Node)node, (String)"exo:mediumSize");
    }

    public Node getSelectedNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRealCurrentNode();
    }

    public Node getThumbnailNode(Node node) throws Exception {
        ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
        return thumbnailService.getThumbnailNode(node);
    }

    public boolean isRemovedThumbnail() {
        return this.thumbnailRemoved_;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIThumbnailForm> {
        public void execute(Event<UIThumbnailForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIThumbnailForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveThumbnailActionListener
    extends EventListener<UIThumbnailForm> {
        public void execute(Event<UIThumbnailForm> event) throws Exception {
            UIThumbnailForm uiForm = (UIThumbnailForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            uiForm.thumbnailRemoved_ = true;
            Node selectedNode = uiExplorer.getRealCurrentNode();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            uiExplorer.addLockToken(selectedNode);
            ThumbnailService thumbnailService = (ThumbnailService)uiForm.getApplicationComponent(ThumbnailService.class);
            Node thumbnailNode = thumbnailService.getThumbnailNode(selectedNode);
            if (thumbnailNode != null) {
                try {
                    thumbnailNode.remove();
                    selectedNode.getSession().save();
                }
                catch (LockException lock) {
                    Object[] arg = new Object[]{selectedNode.getPath()};
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
                    return;
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                    return;
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                    }
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    return;
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            uiExplorer.setIsHidePopup(true);
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIThumbnailForm> {
        public void execute(Event<UIThumbnailForm> event) throws Exception {
            UIThumbnailForm uiForm = (UIThumbnailForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UIFormUploadInput input = (UIFormUploadInput)uiForm.getUIInput(UIThumbnailForm.THUMBNAIL_FIELD);
            if (input.getUploadResource() == null) {
                uiApp.addMessage(new ApplicationMessage("UIUploadForm.msg.fileName-error", null, 1));
                return;
            }
            Node selectedNode = uiExplorer.getRealCurrentNode();
            uiExplorer.addLockToken(selectedNode);
            String fileName = input.getUploadResource().getFileName();
            DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
            String mimeType = mimeTypeSolver.getMimeType(fileName);
            if (!mimeType.startsWith("image")) {
                uiApp.addMessage(new ApplicationMessage("UIThumbnailForm.msg.mimetype-incorrect", null, 1));
                return;
            }
            InputStream inputStream = input.getUploadDataAsStream();
            ThumbnailService thumbnailService = (ThumbnailService)uiForm.getApplicationComponent(ThumbnailService.class);
            BufferedImage image = ImageIO.read(inputStream);
            try {
                thumbnailService.createThumbnailImage(selectedNode, image, mimeType);
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIThumbnailForm.msg.access-denied", null, 1));
                return;
            }
            catch (VersionException ver) {
                uiApp.addMessage(new ApplicationMessage("UIThumbnailForm.msg.is-checked-in", null, 1));
                return;
            }
            catch (LockException lock) {
                Object[] arg = new Object[]{selectedNode.getPath()};
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
                return;
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            selectedNode.getSession().save();
            uiExplorer.updateAjax(event);
        }
    }
}

