/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.jboss.cache.CacheException;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.RPCManager;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.tx.AbstractTransactionCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.context.ContextFactory;
import org.jboss.cache.interceptors.BaseTransactionalContextInterceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.transaction.TransactionLog;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.concurrent.ConcurrentHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxInterceptor
extends BaseTransactionalContextInterceptor {
    protected CommandsFactory commandsFactory;
    protected RPCManager rpcManager;
    private Notifier notifier;
    private InvocationContextContainer invocationContextContainer;
    private ComponentRegistry componentRegistry;
    private ContextFactory contextFactory;
    private TransactionLog transactionLog;
    private final Set<Transaction> transactions = new ConcurrentHashSet<Transaction>();
    private final Map<Transaction, GlobalTransaction> rollbackTransactions = new ConcurrentHashMap<Transaction, GlobalTransaction>(16);
    private long prepares = 0L;
    private long commits = 0L;
    private long rollbacks = 0L;
    protected boolean optimistic = false;
    private LockManager lockManager;
    private boolean statsEnabled;

    @Inject
    public void intialize(RPCManager rpcManager, ContextFactory contextFactory, Notifier notifier, InvocationContextContainer icc, TransactionLog transactionLog, CommandsFactory factory, ComponentRegistry componentRegistry, LockManager lockManager) {
        this.contextFactory = contextFactory;
        this.transactionLog = transactionLog;
        this.commandsFactory = factory;
        this.rpcManager = rpcManager;
        this.notifier = notifier;
        this.invocationContextContainer = icc;
        this.componentRegistry = componentRegistry;
        this.lockManager = lockManager;
        this.setStatisticsEnabled(this.configuration.getExposeManagementStatistics());
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = null;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (this.trace) {
            this.log.trace((Object)("Got gtx from invocation context " + gtx));
        }
        try {
            if (gtx.isRemote()) {
                result = this.handleRemotePrepare(ctx, command);
                if (this.getStatisticsEnabled()) {
                    ++this.prepares;
                }
            } else {
                if (this.trace) {
                    this.log.trace((Object)"received my own message (discarding it)");
                }
                result = null;
            }
        }
        catch (Throwable e) {
            ctx.throwIfNeeded(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (!ctx.getGlobalTransaction().isRemote()) {
            if (!this.trace) return null;
            this.log.trace((Object)"received my own message (discarding it)");
            return null;
        }
        try {
            Transaction ltx;
            block10: {
                if (this.trace) {
                    this.log.trace((Object)("(" + this.rpcManager.getLocalAddress() + ") call on command [" + command + "]"));
                }
                ltx = this.txTable.getLocalTransaction(gtx, true);
                Transaction currentTx = this.txManager.getTransaction();
                boolean resumeCurrentTxOnCompletion = false;
                try {
                    if (!ltx.equals(currentTx)) {
                        currentTx = this.txManager.suspend();
                        resumeCurrentTxOnCompletion = true;
                        this.txManager.resume(ltx);
                        ctx.setTransaction(ltx);
                    }
                    if (this.trace) {
                        this.log.trace((Object)(" executing commit() with local TX " + ltx + " under global tx " + gtx));
                    }
                    this.txManager.commit();
                    if (this.getStatisticsEnabled()) {
                        ++this.commits;
                    }
                    Object var8_8 = null;
                    if (!resumeCurrentTxOnCompletion) break block10;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (resumeCurrentTxOnCompletion) {
                        this.resumeTransactionOnCompletion(ctx, currentTx);
                    }
                    this.transactions.remove(ltx);
                    this.txTable.remove(gtx, ltx);
                    throw throwable;
                }
                this.resumeTransactionOnCompletion(ctx, currentTx);
            }
            this.transactions.remove(ltx);
            this.txTable.remove(gtx, ltx);
            if (!this.trace) return null;
            this.log.trace((Object)("Finished remote rollback method for " + gtx));
            return null;
        }
        catch (Throwable throwable) {
            ctx.throwIfNeeded(throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (!gtx.isRemote()) {
            if (!this.trace) return null;
            this.log.trace((Object)"received my own message (discarding it)");
            return null;
        }
        try {
            Transaction ltx;
            block11: {
                if (this.trace) {
                    this.log.trace((Object)("(" + this.rpcManager.getLocalAddress() + ") call on command [" + command + "]"));
                }
                if ((ltx = this.txTable.getLocalTransaction(gtx)) == null) {
                    this.log.warn((Object)"No local transaction for this remotely originating rollback.  Possibly rolling back before a prepare call was broadcast?");
                    this.txTable.remove(gtx);
                    return null;
                }
                Transaction currentTx = this.txManager.getTransaction();
                boolean resumeCurrentTxOnCompletion = false;
                try {
                    if (!ltx.equals(currentTx)) {
                        currentTx = this.txManager.suspend();
                        resumeCurrentTxOnCompletion = true;
                        this.txManager.resume(ltx);
                        ctx.setTransaction(ltx);
                    }
                    if (this.trace) {
                        this.log.trace((Object)("executing with local TX " + ltx + " under global tx " + gtx));
                    }
                    this.txManager.rollback();
                    if (this.getStatisticsEnabled()) {
                        ++this.rollbacks;
                    }
                    Object var8_8 = null;
                    if (!resumeCurrentTxOnCompletion) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (resumeCurrentTxOnCompletion) {
                        this.resumeTransactionOnCompletion(ctx, currentTx);
                    }
                    this.transactions.remove(ltx);
                    this.txTable.remove(gtx, ltx);
                    throw throwable;
                }
                this.resumeTransactionOnCompletion(ctx, currentTx);
            }
            this.transactions.remove(ltx);
            this.txTable.remove(gtx, ltx);
            if (!this.trace) return null;
            this.log.trace((Object)("Finished remote commit/rollback method for " + gtx));
            return null;
        }
        catch (Throwable throwable) {
            ctx.throwIfNeeded(throwable);
        }
        return null;
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        try {
            Object ret = this.attachGtxAndPassUpChain(ctx, command);
            if (command instanceof WriteCommand && ctx.getTransaction() == null) {
                this.transactionLog.logNoTxWrite((WriteCommand)command);
            }
            return ret;
        }
        catch (Throwable throwable) {
            ctx.throwIfNeeded(throwable);
            return null;
        }
    }

    protected Object attachGtxAndPassUpChain(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Transaction tx = ctx.getTransaction();
        if (tx != null) {
            this.attachGlobalTransaction(ctx, tx, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object handleRemotePrepare(InvocationContext ctx, PrepareCommand command) throws Throwable {
        block41: {
            block35: {
                gtx = ctx.getGlobalTransaction();
                ltx = this.txTable.getLocalTransaction(gtx);
                currentTx = this.txManager.getTransaction();
                retval = null;
                success = false;
                try {
                    if (ltx == null) {
                        if (currentTx != null) {
                            this.txManager.suspend();
                        }
                        ltx = this.createLocalTx();
                        this.txTable.put(ltx, gtx);
                        if (this.trace) {
                            this.log.trace((Object)("Created new tx for gtx " + gtx));
                        }
                        if (this.trace) {
                            this.log.trace((Object)("Started new local tx as result of remote prepare: local tx=" + ltx + " (status=" + ltx.getStatus() + "), gtx=" + gtx));
                        }
                    } else {
                        if (!TransactionTable.isValid(ltx)) {
                            throw new CacheException("Transaction " + ltx + " not in correct state to be prepared");
                        }
                        if (currentTx == null || !ltx.equals(currentTx)) {
                            if (this.trace) {
                                this.log.trace((Object)("Suspending current tx " + currentTx));
                            }
                            this.txManager.suspend();
                            this.txManager.resume(ltx);
                        }
                    }
                    if (this.trace) {
                        this.log.trace((Object)("Resuming existing tx " + ltx + ", global tx=" + gtx));
                    }
                    if ((transactionContext = this.txTable.get(gtx)) == null) {
                        if (this.trace) {
                            this.log.trace((Object)"creating new tx transactionContext");
                        }
                        transactionContext = this.contextFactory.createTransactionContext(ltx);
                        this.txTable.put(gtx, transactionContext);
                    }
                    this.setTransactionalContext(ltx, gtx, transactionContext, ctx);
                    this.registerHandler(ltx, new RemoteSynchronizationHandler(gtx, ltx, transactionContext), ctx);
                    success = false;
                    this.replayModifications(ctx, ltx, command);
                    success = true;
                    if (command.isOnePhaseCommit()) {
                        if (this.trace) {
                            this.log.trace((Object)"Using one-phase prepare.  Not propagating the prepare call up the stack until called to do so by the sync handler.");
                        }
                    } else {
                        this.transactionLog.logPrepare(command);
                        this.invokeNextInterceptor(ctx, command);
                    }
                    this.assertTxIsStillValid(ltx);
                    var10_9 = null;
                    if (!this.trace) break block35;
                }
                catch (Throwable var9_23) {
                    block38: {
                        var10_10 = null;
                        if (this.trace) {
                            this.log.trace((Object)("Are we running a 1-phase commit? " + command.isOnePhaseCommit()));
                        }
                        if (command.isOnePhaseCommit()) {
                            try {
                                try {
                                    if (success) {
                                        ltx.commit();
                                    } else {
                                        ltx.rollback();
                                    }
                                }
                                catch (Throwable t) {
                                    this.log.error((Object)"Commit/rollback failed.", t);
                                    if (success) {
                                        try {
                                            this.log.info((Object)"Attempting anotehr rollback");
                                            ltx.rollback();
                                        }
                                        catch (Throwable t2) {
                                            this.log.error((Object)"Unable to rollback", t2);
                                        }
                                    }
                                    var14_15 = null;
                                    this.transactions.remove(ltx);
                                    break block38;
                                }
                                var14_14 = null;
                                this.transactions.remove(ltx);
                            }
                            catch (Throwable var13_22) {
                                var14_16 = null;
                                this.transactions.remove(ltx);
                                throw var13_22;
                            }
                        }
                    }
                    this.txManager.suspend();
                    if (currentTx != null) {
                        this.txManager.resume(currentTx);
                    }
                    if (this.trace == false) throw var9_23;
                    this.log.trace((Object)("Finished remote prepare " + gtx));
                    throw var9_23;
                }
                this.log.trace((Object)("Are we running a 1-phase commit? " + command.isOnePhaseCommit()));
            }
            if (!command.isOnePhaseCommit()) break block41;
            try {}
            catch (Throwable var13_21) {
                var14_13 = null;
                this.transactions.remove(ltx);
                throw var13_21;
            }
            try {}
            catch (Throwable t) {
                block40: {
                    this.log.error((Object)"Commit/rollback failed.", t);
                    if (success) {
                        ** try [egrp 3[TRYBLOCK] [3 : 582->603)] { 
lbl111:
                        // 1 sources

                        this.log.info((Object)"Attempting anotehr rollback");
                        ltx.rollback();
                        break block40;
lbl114:
                        // 1 sources

                        catch (Throwable t2) {
                            this.log.error((Object)"Unable to rollback", t2);
                        }
                    }
                }
                var14_12 = null;
                this.transactions.remove(ltx);
                break block41;
            }
            if (success) {
                ltx.commit();
            } else {
                ltx.rollback();
            }
            var14_11 = null;
            this.transactions.remove(ltx);
        }
        this.txManager.suspend();
        if (currentTx != null) {
            this.txManager.resume(currentTx);
        }
        if (this.trace == false) return retval;
        this.log.trace((Object)("Finished remote prepare " + gtx));
        return retval;
    }

    private ReplicableCommand attachGlobalTransaction(InvocationContext ctx, Transaction tx, VisitableCommand command) throws Throwable {
        GlobalTransaction gtx;
        if (this.trace) {
            this.log.trace((Object)(" local transaction exists - registering global tx if not present for " + Thread.currentThread()));
        }
        if (this.trace) {
            GlobalTransaction tempGtx = this.txTable.get(tx);
            this.log.trace((Object)("Associated gtx in txTable is " + tempGtx));
        }
        if ((gtx = this.registerTransaction(tx, ctx)) != null) {
            command = this.replaceGtx(command, gtx);
        } else {
            gtx = this.txTable.get(tx);
        }
        ctx.setGlobalTransaction(gtx);
        return command;
    }

    protected void replayModifications(InvocationContext ctx, Transaction ltx, PrepareCommand command) throws Throwable {
        try {
            for (WriteCommand modification : command.getModifications()) {
                this.invokeNextInterceptor(ctx, modification);
                this.assertTxIsStillValid(ltx);
            }
        }
        catch (Throwable th) {
            this.log.error((Object)"prepare failed!", th);
            throw th;
        }
    }

    private void resumeTransactionOnCompletion(InvocationContext ctx, Transaction currentTx) throws SystemException, InvalidTransactionException {
        if (this.trace) {
            this.log.trace((Object)("Resuming suspended transaction " + currentTx));
        }
        this.txManager.suspend();
        if (currentTx != null) {
            this.txManager.resume(currentTx);
            ctx.setTransaction(currentTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleCommitRollback(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Object result;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        VisitableCommand originalCommand = ctx.getCommand();
        ctx.setCommand(command);
        try {
            result = this.invokeNextInterceptor(ctx, command);
            Object var7_6 = null;
            ctx.setCommand(originalCommand);
            ctx.setMethodCall(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ctx.setCommand(originalCommand);
            ctx.setMethodCall(null);
            throw throwable;
        }
        if (this.trace) {
            this.log.trace((Object)("Finished local commit/rollback method for " + gtx));
        }
        return result;
    }

    protected PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List modifications, boolean onePhaseCommit) {
        return this.commandsFactory.buildPrepareCommand(gtx, modifications, this.rpcManager.getLocalAddress(), onePhaseCommit);
    }

    protected void runCommitPhase(InvocationContext ctx, GlobalTransaction gtx, List modifications, boolean onePhaseCommit) {
        try {
            if (this.trace) {
                this.log.trace((Object)("Running commit for " + gtx));
            }
            AbstractTransactionCommand commitCommand = onePhaseCommit ? this.buildPrepareCommand(gtx, modifications, true) : this.commandsFactory.buildCommitCommand(gtx);
            this.handleCommitRollback(ctx, commitCommand);
            if (onePhaseCommit) {
                this.transactionLog.logOnePhaseCommit(gtx, modifications);
            } else {
                this.transactionLog.logCommit(gtx);
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)"Commit failed.  Clearing stale locks.");
            try {
                this.cleanupStaleLocks(ctx);
            }
            catch (RuntimeException re) {
                this.log.error((Object)"Unable to clear stale locks", (Throwable)re);
                throw re;
            }
            catch (Throwable e2) {
                this.log.error((Object)"Unable to clear stale locks", e2);
                throw new RuntimeException(e2);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Commit failed.", e);
        }
    }

    protected void cleanupStaleLocks(InvocationContext ctx) throws Throwable {
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (transactionContext != null) {
            this.lockManager.unlock(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runRollbackPhase(InvocationContext ctx, GlobalTransaction gtx, Transaction tx) {
        try {
            try {
                RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(gtx);
                if (this.trace) {
                    this.log.trace((Object)(" running rollback for " + gtx));
                }
                this.transactionLog.rollback(gtx);
                this.rollbackTransactions.put(tx, gtx);
                this.handleCommitRollback(ctx, rollbackCommand);
            }
            catch (Throwable e) {
                this.log.warn((Object)"Rollback had a problem", e);
                Object var6_7 = null;
                this.rollbackTransactions.remove(tx);
                return;
            }
            Object var6_6 = null;
            this.rollbackTransactions.remove(tx);
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.rollbackTransactions.remove(tx);
            throw throwable;
        }
    }

    private boolean isOnePhaseCommit() {
        if (!this.configuration.getCacheMode().isSynchronous() && !this.optimistic) {
            if (this.trace) {
                this.log.trace((Object)"This is a REPL_ASYNC call (1 phase commit) - do nothing for beforeCompletion()");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runPreparePhase(InvocationContext ctx, GlobalTransaction gtx, List<WriteCommand> modifications) throws Throwable {
        Object result;
        PrepareCommand prepareCommand = this.buildPrepareCommand(gtx, modifications, false);
        this.transactionLog.logPrepare(prepareCommand);
        Transaction ltx = ctx.getTransaction();
        Transaction currentTransaction = this.txManager.getTransaction();
        if (currentTransaction != null && ltx != null && currentTransaction.equals(ltx)) {
            VisitableCommand originalCommand = ctx.getCommand();
            ctx.setCommand(prepareCommand);
            try {
                result = this.invokeNextInterceptor(ctx, prepareCommand);
                Object var10_9 = null;
                ctx.setCommand(originalCommand);
                ctx.setMethodCall(null);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ctx.setCommand(originalCommand);
                ctx.setMethodCall(null);
                throw throwable;
            }
        } else {
            this.log.warn((Object)("Local transaction does not exist or does not match expected transaction " + gtx));
            throw new CacheException(" local transaction " + ltx + " does not exist or does not match expected transaction " + gtx);
        }
        return result;
    }

    protected void assertTxIsStillValid(Transaction tx) {
        if (!TransactionTable.isActive(tx)) {
            try {
                throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + tx.getStatus());
            }
            catch (SystemException e) {
                throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; Unable to retrieve transaction status.");
            }
        }
    }

    private GlobalTransaction registerTransaction(Transaction tx, InvocationContext ctx) throws Exception {
        GlobalTransaction gtx;
        boolean txValid = TransactionTable.isValid(tx);
        if (!txValid) {
            throw new IllegalStateException("Transaction " + tx + " is not in a valid state to be invoking cache operations on.");
        }
        if (this.transactions.add(tx)) {
            TransactionContext transactionContext;
            gtx = this.txTable.getCurrentTransaction(tx, true);
            if (ctx.getGlobalTransaction() == null) {
                ctx.setGlobalTransaction(gtx);
                transactionContext = this.txTable.get(gtx);
                ctx.setTransactionContext(transactionContext);
            } else {
                transactionContext = ctx.getTransactionContext();
            }
            if (gtx.isRemote()) {
                if (this.trace) {
                    this.log.trace((Object)"is a remotely initiated gtx so no need to register a tx for it");
                }
            } else {
                if (this.trace) {
                    this.log.trace((Object)("Registering sync handler for tx " + tx + ", gtx " + gtx));
                }
                LocalSynchronizationHandler myHandler = new LocalSynchronizationHandler(gtx, tx, transactionContext, !ctx.isOriginLocal());
                this.registerHandler(tx, myHandler, ctx);
            }
        } else {
            gtx = this.rollbackTransactions.get(tx);
            if (gtx != null) {
                if (this.trace) {
                    this.log.trace((Object)("Transaction " + tx + " is already registered and is rolling back."));
                }
            } else if (this.trace) {
                this.log.trace((Object)("Transaction " + tx + " is already registered."));
            }
        }
        return gtx;
    }

    private void registerHandler(Transaction tx, Synchronization handler, InvocationContext ctx) throws Exception {
        OrderedSynchronizationHandler orderedHandler = ctx.getTransactionContext().getOrderedSynchronizationHandler();
        if (this.trace) {
            this.log.trace((Object)("registering for TX completion: SynchronizationHandler(" + handler + ")"));
        }
        orderedHandler.registerAtHead(handler);
        this.notifier.notifyTransactionRegistered(tx, ctx);
    }

    private VisitableCommand replaceGtx(VisitableCommand command, final GlobalTransaction gtx) throws Throwable {
        command.acceptVisitor(null, new AbstractVisitor(){

            public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }

            public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
                command.setGlobalTransaction(gtx);
                return null;
            }
        });
        return command;
    }

    protected Transaction createLocalTx() throws Exception {
        if (this.trace) {
            this.log.trace((Object)("Creating transaction for thread " + Thread.currentThread()));
        }
        if (this.txManager == null) {
            throw new Exception("Failed to create local transaction; TransactionManager is null");
        }
        this.txManager.begin();
        Transaction localTx = this.txManager.getTransaction();
        return localTx;
    }

    @ManagedOperation
    public void resetStatistics() {
        this.prepares = 0L;
        this.commits = 0L;
        this.rollbacks = 0L;
    }

    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>(3);
        retval.put("Prepares", this.prepares);
        retval.put("Commits", this.commits);
        retval.put("Rollbacks", this.rollbacks);
        return retval;
    }

    @ManagedAttribute
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @ManagedAttribute(description="number of transaction prepares")
    public long getPrepares() {
        return this.prepares;
    }

    @ManagedAttribute(description="number of transaction commits")
    public long getCommits() {
        return this.commits;
    }

    @ManagedAttribute(description="number of transaction rollbacks")
    public long getRollbacks() {
        return this.rollbacks;
    }

    @ManagedAttribute(name="numberOfSyncsRegistered", writable=false, description="number of transaction synchronizations currently registered")
    public int getNumberOfSyncsRegistered() {
        return this.transactions.size();
    }

    static /* synthetic */ Log access$400(TxInterceptor x0) {
        return x0.log;
    }

    static /* synthetic */ boolean access$500(TxInterceptor x0) {
        return x0.trace;
    }

    static /* synthetic */ Log access$600(TxInterceptor x0) {
        return x0.log;
    }

    static /* synthetic */ Set access$700(TxInterceptor x0) {
        return x0.transactions;
    }

    static /* synthetic */ boolean access$900(TxInterceptor x0) {
        return x0.trace;
    }

    static /* synthetic */ Log access$1000(TxInterceptor x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1100(TxInterceptor x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1200(TxInterceptor x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1300(TxInterceptor x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1400(TxInterceptor x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$1500(TxInterceptor x0) {
        return x0.log;
    }

    private class LocalSynchronizationHandler
    extends RemoteSynchronizationHandler {
        private boolean localRollbackOnly;
        private boolean remoteLocal;
        private Option originalOptions;
        private Option transactionalOptions;

        LocalSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TransactionContext transactionContext, boolean remoteLocal) {
            super(gtx, tx, transactionContext);
            this.localRollbackOnly = true;
            this.remoteLocal = false;
            this.remoteLocal = remoteLocal;
        }

        public void beforeCompletion() {
            super.beforeCompletion();
            this.ctx.setOriginLocal(!this.remoteLocal);
            TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
            if (!this.transactionContext.hasModifications()) {
                if (TxInterceptor.this.trace) {
                    TxInterceptor.this.log.trace((Object)"No modifications in this tx.  Skipping beforeCompletion()");
                }
                this.modifications = Collections.emptyList();
                return;
            }
            this.modifications = this.transactionContext.getModifications();
            this.originalOptions = this.ctx.getOptionOverrides();
            this.transactionalOptions = this.transactionContext.getOption();
            this.transactionalOptions.setSuppressEventNotification(this.originalOptions.isSuppressEventNotification());
            this.ctx.setOptionOverrides(this.transactionalOptions);
            try {
                try {
                    switch (this.tx.getStatus()) {
                        case 0: 
                        case 7: {
                            Object result;
                            Object object = result = TxInterceptor.this.isOnePhaseCommit() ? null : TxInterceptor.this.runPreparePhase(this.ctx, this.gtx, this.modifications);
                            if (!(result instanceof Throwable)) break;
                            if (TxInterceptor.this.log.isDebugEnabled()) {
                                TxInterceptor.this.log.debug((Object)("Transaction needs to be rolled back - the cache returned an instance of Throwable for this prepare call (tx=" + this.tx + " and gtx=" + this.gtx + ")"), (Throwable)result);
                            }
                            this.tx.setRollbackOnly();
                            throw (Throwable)result;
                        }
                        default: {
                            throw new CacheException("transaction " + this.tx + " in status " + this.tx.getStatus() + " unable to start transaction");
                        }
                    }
                    Object var4_3 = null;
                    this.localRollbackOnly = false;
                }
                catch (Throwable t) {
                    if (TxInterceptor.this.log.isWarnEnabled()) {
                        TxInterceptor.this.log.warn((Object)"Caught exception, will now set transaction to roll back", t);
                    }
                    try {
                        this.tx.setRollbackOnly();
                    }
                    catch (SystemException se) {
                        throw new RuntimeException("setting tx rollback failed ", se);
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("", t);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.localRollbackOnly = false;
                TxInterceptor.this.setTransactionalContext(null, null, null, this.ctx);
                this.ctx.setOptionOverrides(this.originalOptions);
                throw throwable;
            }
            TxInterceptor.this.setTransactionalContext(null, null, null, this.ctx);
            this.ctx.setOptionOverrides(this.originalOptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (this.ctx == null) {
                this.ctx = (InvocationContext)TxInterceptor.this.invocationContextContainer.get();
            }
            this.ctx.setLocalRollbackOnly(this.localRollbackOnly);
            TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
            if (this.transactionalOptions != null) {
                this.ctx.setOptionOverrides(this.transactionalOptions);
            }
            try {
                super.afterCompletion(status);
                Object var3_2 = null;
                this.ctx.setOptionOverrides(this.originalOptions);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.ctx.setOptionOverrides(this.originalOptions);
                throw throwable;
            }
        }

        public String toString() {
            return "TxInterceptor.LocalSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.getTxAsString() + ")";
        }
    }

    private class RemoteSynchronizationHandler
    implements Synchronization {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        List<WriteCommand> modifications = null;
        TransactionContext transactionContext = null;
        protected InvocationContext ctx;

        RemoteSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TransactionContext entry) {
            this.gtx = gtx;
            this.tx = tx;
            this.transactionContext = entry;
        }

        public void beforeCompletion() {
            if (TxInterceptor.this.trace) {
                TxInterceptor.this.log.trace((Object)("Running beforeCompletion on gtx " + this.gtx));
            }
            if (this.transactionContext == null) {
                TxInterceptor.this.log.error((Object)"Transaction has a null transaction entry - beforeCompletion() will fail.");
                throw new IllegalStateException("cannot find transaction entry for " + this.gtx);
            }
            this.modifications = this.transactionContext.getModifications();
            this.ctx = (InvocationContext)TxInterceptor.this.invocationContextContainer.get();
            TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
            if (this.ctx.isOptionsUninitialised() && this.transactionContext.getOption() != null) {
                this.ctx.setOptionOverrides(this.transactionContext.getOption());
            }
            this.assertCanContinue();
            this.ctx.setOriginLocal(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void afterCompletion(int status) {
            block19: {
                if (this.ctx == null) {
                    this.ctx = (InvocationContext)TxInterceptor.access$300(TxInterceptor.this).get();
                    TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
                    if (this.ctx.isOptionsUninitialised() && this.transactionContext != null && this.transactionContext.getOption() != null) {
                        this.ctx.setOptionOverrides(this.transactionContext.getOption());
                    }
                }
                try {
                    this.assertCanContinue();
                    try {
                        if (TxInterceptor.this.txManager.getTransaction() != null && !TxInterceptor.this.txManager.getTransaction().equals(this.tx)) {
                            TxInterceptor.this.txManager.resume(this.tx);
                        }
                    }
                    catch (Exception e) {
                        TxInterceptor.access$400(TxInterceptor.this).error((Object)("afterCompletion error: " + status), (Throwable)e);
                    }
                    if (TxInterceptor.access$500(TxInterceptor.this)) {
                        TxInterceptor.access$600(TxInterceptor.this).trace((Object)("calling aftercompletion for " + this.gtx));
                    }
                    if (this.transactionContext != null) {
                        if (this.modifications == null) {
                            this.modifications = this.transactionContext.getModifications();
                        }
                        isSuppressEventNotification = this.ctx.getOptionOverrides().isSuppressEventNotification();
                        this.ctx.setOptionOverrides(this.transactionContext.getOption());
                        this.ctx.getOptionOverrides().setSuppressEventNotification(isSuppressEventNotification);
                    }
                    if (this.tx != null) {
                        TxInterceptor.access$700(TxInterceptor.this).remove(this.tx);
                    }
                    switch (status) {
                        case 3: {
                            onePhaseCommit = TxInterceptor.access$800(TxInterceptor.this);
                            if (TxInterceptor.access$900(TxInterceptor.this)) {
                                TxInterceptor.access$1000(TxInterceptor.this).trace((Object)("Running commit phase.  One phase? " + onePhaseCommit));
                            }
                            TxInterceptor.this.runCommitPhase(this.ctx, this.gtx, this.modifications, onePhaseCommit);
                            TxInterceptor.access$1100(TxInterceptor.this).trace((Object)"Finished commit phase");
                            ** break;
                        }
                        case 5: {
                            TxInterceptor.access$1200(TxInterceptor.this).warn((Object)"Received JTA STATUS_UNKNOWN in afterCompletion()!  XA resources may not be in sync.  The app should manually clean up resources at this point.");
                        }
                        case 1: 
                        case 4: {
                            TxInterceptor.access$1300(TxInterceptor.this).trace((Object)"Running rollback phase");
                            TxInterceptor.this.runRollbackPhase(this.ctx, this.gtx, this.tx);
                            TxInterceptor.access$1400(TxInterceptor.this).trace((Object)"Finished rollback phase");
                            ** break;
                        }
                        default: {
                            throw new IllegalStateException("illegal status: " + status);
lbl43:
                            // 2 sources

                            break;
                        }
                    }
                    var4_6 = null;
                    TxInterceptor.this.txTable.remove(this.gtx);
                }
                catch (Throwable var3_9) {
                    var4_8 = null;
                    TxInterceptor.this.txTable.remove(this.gtx);
                    TxInterceptor.this.txTable.remove(this.tx);
                    TxInterceptor.this.setTransactionalContext(null, null, null, this.ctx);
                    this.cleanupInternalState();
                    throw var3_9;
                }
                TxInterceptor.this.txTable.remove(this.tx);
                TxInterceptor.this.setTransactionalContext(null, null, null, this.ctx);
                this.cleanupInternalState();
                {
                    break block19;
                    catch (Exception th) {
                        TxInterceptor.access$1500(TxInterceptor.this).trace((Object)"Caught exception ", (Throwable)th);
                        var4_7 = null;
                        TxInterceptor.this.txTable.remove(this.gtx);
                        TxInterceptor.this.txTable.remove(this.tx);
                        TxInterceptor.this.setTransactionalContext(null, null, null, this.ctx);
                        this.cleanupInternalState();
                    }
                }
            }
        }

        private void assertCanContinue() {
            if (!(TxInterceptor.this.componentRegistry.invocationsAllowed(true) || this.ctx.getOptionOverrides() != null && this.ctx.getOptionOverrides().isSkipCacheStatusCheck())) {
                throw new IllegalStateException("Cache not in STARTED state!");
            }
        }

        private void cleanupInternalState() {
            this.tx = null;
            this.gtx = null;
            this.modifications = null;
            if (this.transactionContext != null) {
                this.transactionContext.reset();
            }
            this.transactionContext = null;
        }

        public String toString() {
            return "TxInterceptor.RemoteSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.getTxAsString() + ")";
        }

        protected String getTxAsString() {
            if (this.tx == null) {
                return null;
            }
            return this.tx.getClass().getName() + "@" + System.identityHashCode(this.tx);
        }
    }
}

