/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.RewriterTestCase;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import java.util.Map;

public class RewriterTest
extends RewriterTestCase {
    public void setUp() throws Exception {
        super.setUp();
    }

    public final void testReturningExactInputIsCaught() throws Exception {
        this.setRewriter(new ReturnExactInputRewriter(this.mq, true));
        this.checkAddsMessage(this.js(this.fromString("3;")), RewriterMessageType.UNSEEN_NODE_LEFT_OVER, MessageLevel.FATAL_ERROR);
        this.setRewriter(new ReturnExactInputRewriter(this.mq, false));
        this.checkSucceeds(this.js(this.fromString("3;")), null);
    }

    public final void testReturningUnexpandedIsCaught() throws Exception {
        this.setRewriter(new ReturnUnexpandedRewriter(this.mq, true));
        this.checkAddsMessage(this.makeSimpleAdditionExpr(), RewriterMessageType.UNSEEN_NODE_LEFT_OVER, MessageLevel.FATAL_ERROR);
        this.setRewriter(new ReturnUnexpandedRewriter(this.mq, false));
        this.checkSucceeds(this.makeSimpleAdditionExpr(), null);
    }

    public final void testUnmatchedThrowsError() throws Exception {
        this.setRewriter(new Rewriter(this.mq, true, true){});
        this.checkAddsMessage(this.js(this.fromString("3;")), RewriterMessageType.UNMATCHED_NODE_LEFT_OVER, MessageLevel.FATAL_ERROR);
    }

    private ParseTreeNode makeSimpleAdditionExpr() throws Exception {
        return this.jsExpr(this.fromString("1 + 2"));
    }

    protected Object executePlain(String program) {
        throw new UnsupportedOperationException();
    }

    protected Object rewriteAndExecute(String pre, String program, String post) {
        throw new UnsupportedOperationException();
    }

    private static class ReturnUnexpandedRewriter
    extends Rewriter {
        public ReturnUnexpandedRewriter(MessageQueue mq, final boolean returnUnexpanded) {
            super(mq, true, true);
            this.addRule(new Rule(){

                @RuleDescription(name="quasiSubst", matches="@x + @y", substitutes="@x - @y", synopsis="", reason="")
                public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                    Map<String, ParseTreeNode> m = this.match(node);
                    if (m != null) {
                        ParseTreeNode x = m.get("x");
                        ParseTreeNode y = m.get("y");
                        if (!returnUnexpanded) {
                            x = this.expandAll(x, scope);
                            y = this.expandAll(y, scope);
                        }
                        return this.substV("x", x, "y", y);
                    }
                    return NONE;
                }
            });
            this.addRule(new Rule(){

                @RuleDescription(name="numberLiteral", synopsis="", reason="")
                public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                    if (node instanceof NumberLiteral) {
                        node.getAttributes().remove(ParseTreeNode.TAINTED);
                        return node;
                    }
                    return NONE;
                }
            });
        }
    }

    private static class ReturnExactInputRewriter
    extends Rewriter {
        public ReturnExactInputRewriter(MessageQueue mq, final boolean returnExactInput) {
            super(mq, true, true);
            this.addRule(new Rule(){

                @RuleDescription(name="setTaint", synopsis="", reason="")
                public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                    if (returnExactInput) {
                        return node;
                    }
                    node.getAttributes().remove(ParseTreeNode.TAINTED);
                    for (ParseTreeNode parseTreeNode : node.children()) {
                        this.getRewriter().expand(parseTreeNode, scope);
                    }
                    return node;
                }
            });
        }
    }
}

