/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.exoplatform.ecms.xcmis.sp.ResultImpl;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.result.ScoredRow;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.query.Result;
import org.xcmis.spi.query.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultIterator
implements ItemsIterator<Result> {
    private final Iterator<ScoredRow> rows;
    private final Set<SelectorName> selectors;
    private final int size;
    private final Query qom;
    private Result next;

    public QueryResultIterator(List<ScoredRow> rows, Query qom) {
        this.size = rows.size();
        this.rows = rows.iterator();
        this.selectors = Visitors.getSelectorsReferencedBy((QueryElement)qom);
        this.qom = qom;
        this.fetchNext();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Result next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Result r = this.next;
        this.fetchNext();
        return r;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public int size() {
        return this.size;
    }

    public void skip(int skip) throws NoSuchElementException {
        while (skip-- > 0) {
            this.next();
        }
    }

    protected void fetchNext() {
        this.next = null;
        while (this.next == null && this.rows.hasNext()) {
            ScoredRow row = this.rows.next();
            for (SelectorName selectorName : this.selectors) {
                String objectId = row.getNodeIdentifer(selectorName.getName());
                ArrayList<String> properties = null;
                Score score = null;
                for (Column column : this.qom.getColumns()) {
                    if (column.isFunction()) {
                        score = new Score(column.getColumnName(), BigDecimal.valueOf(row.getScore()));
                        continue;
                    }
                    if (!selectorName.getName().equals(column.getSelectorName()) || column.getPropertyName() == null) continue;
                    if (properties == null) {
                        properties = new ArrayList<String>();
                    }
                    properties.add(column.getPropertyName());
                }
                this.next = new ResultImpl(objectId, properties == null ? null : properties.toArray(new String[properties.size()]), score);
            }
        }
    }
}

