/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.common;

import java.awt.Adjustable;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.icepdf.core.views.DocumentViewController;

public class PanningHandler
implements MouseMotionListener,
MouseListener {
    private DocumentViewController documentViewController;
    private Point lastMousePosition = new Point();

    public PanningHandler(DocumentViewController documentViewController) {
        this.documentViewController = documentViewController;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().getViewToolMode() == 1) {
            Adjustable verticalScrollbar = this.documentViewController.getVerticalScrollBar();
            Adjustable horizontalScrollbar = this.documentViewController.getHorizontalScrollBar();
            if (verticalScrollbar != null && horizontalScrollbar != null) {
                Point p = new Point((int)e.getPoint().getX() - horizontalScrollbar.getValue(), (int)e.getPoint().getY() - verticalScrollbar.getValue());
                int x = (int)((double)horizontalScrollbar.getValue() - (p.getX() - this.lastMousePosition.getX()));
                int y = (int)((double)verticalScrollbar.getValue() - (p.getY() - this.lastMousePosition.getY()));
                horizontalScrollbar.setValue(x);
                verticalScrollbar.setValue(y);
                this.lastMousePosition.setLocation(p);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().getViewToolMode() == 1) {
            Adjustable verticalScrollbar = this.documentViewController.getVerticalScrollBar();
            Adjustable horizontalScrollbar = this.documentViewController.getHorizontalScrollBar();
            this.lastMousePosition.setLocation(e.getPoint().getX() - (double)horizontalScrollbar.getValue(), e.getPoint().getY() - (double)verticalScrollbar.getValue());
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().isViewToolModeSelected(1)) {
            this.documentViewController.setViewCursor(2);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().getViewToolMode() == 1) {
            this.documentViewController.setViewCursor(1);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

