/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Printer {
    private SessionFactoryImplementor factory;
    private static final Logger log = LoggerFactory.getLogger((Class)Printer.class);

    public String toString(Object entity, EntityMode entityMode) throws HibernateException {
        ClassMetadata cm = this.factory.getClassMetadata(entity.getClass());
        if (cm == null) {
            return entity.getClass().getName();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (cm.hasIdentifierProperty()) {
            result.put(cm.getIdentifierPropertyName(), cm.getIdentifierType().toLoggableString(cm.getIdentifier(entity, entityMode), this.factory));
        }
        Type[] types = cm.getPropertyTypes();
        String[] names = cm.getPropertyNames();
        Object[] values = cm.getPropertyValues(entity, entityMode);
        for (int i = 0; i < types.length; ++i) {
            if (names[i].startsWith("_")) continue;
            String strValue = values[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? values[i].toString() : types[i].toLoggableString(values[i], this.factory);
            result.put(names[i], strValue);
        }
        return cm.getEntityName() + ((Object)result).toString();
    }

    public String toString(Type[] types, Object[] values) throws HibernateException {
        ArrayList<String> list = new ArrayList<String>(types.length * 5);
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null) continue;
            list.add(types[i].toLoggableString(values[i], this.factory));
        }
        return ((Object)list).toString();
    }

    public String toString(Map namedTypedValues) throws HibernateException {
        HashMap result = new HashMap();
        Iterator iter = namedTypedValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            TypedValue tv = (TypedValue)me.getValue();
            result.put(me.getKey(), tv.getType().toLoggableString(tv.getValue(), this.factory));
        }
        return ((Object)result).toString();
    }

    public void toString(Iterator iter, EntityMode entityMode) throws HibernateException {
        if (!log.isDebugEnabled() || !iter.hasNext()) {
            return;
        }
        log.debug("listing entities:");
        int i = 0;
        while (iter.hasNext()) {
            if (i++ > 20) {
                log.debug("more......");
                break;
            }
            log.debug(this.toString(iter.next(), entityMode));
        }
    }

    public Printer(SessionFactoryImplementor factory) {
        this.factory = factory;
    }
}

