/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.ELText;
import com.sun.facelets.el.TagMethodExpression;
import com.sun.facelets.el.TagValueExpression;
import com.sun.facelets.tag.Location;
import com.sun.facelets.tag.TagAttributeException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

public final class TagAttribute {
    private final boolean literal;
    private final String localName;
    private final Location location;
    private final String namespace;
    private final String qName;
    private final String value;
    private String string;

    public TagAttribute(Location location, String ns, String localName, String qName, String value) {
        this.location = location;
        this.namespace = ns;
        this.localName = localName;
        this.qName = qName;
        this.value = value;
        try {
            this.literal = ELText.isLiteral(this.value);
        }
        catch (ELException e) {
            throw new TagAttributeException(this, (Throwable)e);
        }
    }

    public boolean getBoolean(FaceletContext ctx) {
        if (this.literal) {
            return Boolean.valueOf(this.value);
        }
        return (Boolean)this.getObject(ctx, Boolean.class);
    }

    public int getInt(FaceletContext ctx) {
        if (this.literal) {
            return Integer.parseInt(this.value);
        }
        return ((Number)this.getObject(ctx, Integer.class)).intValue();
    }

    public String getLocalName() {
        return this.localName;
    }

    public Location getLocation() {
        return this.location;
    }

    public MethodExpression getMethodExpression(FaceletContext ctx, Class type, Class[] paramTypes) {
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            return new TagMethodExpression(this, f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes));
        }
        catch (Exception e) {
            throw new TagAttributeException(this, (Throwable)e);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getObject(FaceletContext ctx) {
        return this.getObject(ctx, Object.class);
    }

    public String getQName() {
        return this.qName;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(FaceletContext ctx) {
        if (this.literal) {
            return this.value;
        }
        return (String)this.getObject(ctx, String.class);
    }

    public Object getObject(FaceletContext ctx, Class type) {
        if (this.literal) {
            if (String.class.equals(type)) {
                return this.value;
            }
            try {
                return ctx.getExpressionFactory().coerceToType((Object)this.value, type);
            }
            catch (Exception e) {
                throw new TagAttributeException(this, (Throwable)e);
            }
        }
        ValueExpression ve = this.getValueExpression(ctx, type);
        try {
            return ve.getValue((ELContext)ctx);
        }
        catch (Exception e) {
            throw new TagAttributeException(this, (Throwable)e);
        }
    }

    public ValueExpression getValueExpression(FaceletContext ctx, Class type) {
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            return new TagValueExpression(this, f.createValueExpression((ELContext)ctx, this.value, type));
        }
        catch (Exception e) {
            throw new TagAttributeException(this, (Throwable)e);
        }
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.location + " " + this.qName + "=\"" + this.value + "\"";
        }
        return this.string;
    }
}

