/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.EJB;
import org.jboss.injection.AbstractHandler;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBInjectionHandler<X extends RemoteEnvironment>
extends AbstractHandler<X> {
    protected String getEncName(EJB ref, Field field) {
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
        return encName;
    }

    protected String getEncName(EJB ref, Method method) {
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(method) : "env/" + encName;
        return encName;
    }

    @Override
    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        EJB ref = container.getAnnotation(EJB.class, field);
        if (ref == null) {
            return;
        }
        String encName = this.getEncName(ref, field);
        injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        EJB ref = container.getAnnotation(EJB.class, method);
        if (ref == null) {
            return;
        }
        String encName = this.getEncName(ref, method);
        injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
    }

    @Override
    public void loadXml(X xml, InjectionContainer container) {
    }
}

