/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.deployer.env;

import org.jboss.beans.metadata.api.annotations.Constructor;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDependencyCreator {
    private Controller controller;

    @Constructor
    public DynamicDependencyCreator(@Inject(bean="jboss.kernel:service=KernelController") Controller controller) {
        this.controller = controller;
    }

    public void createDepenencies(Object targetName, Iterable<String> dependencies, String whenRequiredState, String dependentState) {
        if (targetName == null) {
            throw new IllegalArgumentException("Null target name");
        }
        if (dependencies == null) {
            throw new IllegalArgumentException("Null dependecies");
        }
        ControllerContext targetControllerContext = this.controller.getContext(targetName, null);
        if (targetControllerContext == null) {
            throw new IllegalArgumentException("No such target bean installed: " + targetName);
        }
        Throwable error = targetControllerContext.getError();
        if (error != null) {
            throw new IllegalArgumentException("Target bean " + targetName + " is in Error state: " + error);
        }
        ControllerState whenRequired = whenRequiredState == null ? ControllerState.INSTALLED : new ControllerState(whenRequiredState);
        ControllerState currentTargetState = targetControllerContext.getState();
        if (!this.controller.getStates().isBeforeState(currentTargetState, whenRequired)) {
            throw new IllegalArgumentException("Target bean " + targetName + " is already past " + whenRequiredState + " state: " + targetControllerContext);
        }
        ControllerState dependent = null;
        if (dependentState != null) {
            dependent = new ControllerState(dependentState);
        }
        DependencyInfo di = targetControllerContext.getDependencyInfo();
        for (String dependency : dependencies) {
            AbstractDependencyItem item = new AbstractDependencyItem(targetName, (Object)dependency, whenRequired, dependent);
            di.addIDependOn((DependencyItem)item);
        }
    }
}

