/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParameterList;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPElementWriter;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.attachment.MultipartRelatedEncoder;

public class MultipartRelatedXOPEncoder
extends MultipartRelatedEncoder {
    public MultipartRelatedXOPEncoder(SOAPMessageImpl soapMessage) throws SOAPException {
        super(soapMessage);
    }

    public void encodeMultipartRelatedMessage() throws SOAPException, MessagingException {
        SOAPEnvelope soapEnv = this.soapMessage.getSOAPPart().getEnvelope();
        boolean isSoap12 = "http://www.w3.org/2003/05/soap-envelope".equals(soapEnv.getElementQName().getNamespaceURI());
        String soapType = isSoap12 ? "application/soap+xml" : "text/xml";
        ParameterList p = new ParameterList();
        p.set("type", "application/xop+xml");
        p.set("start", "<rootpart@ws.jboss.org>");
        p.set("start-info", soapType);
        MimeMultipart multipart = new MimeMultipart("related" + p);
        MimeBodyPart rootPart = new MimeBodyPart();
        String envStr = SOAPElementWriter.writeElement((SOAPElementImpl)soapEnv, false);
        rootPart.setText(envStr, "UTF-8");
        rootPart.setContentID("<rootpart@ws.jboss.org>");
        rootPart.setHeader("Content-Type", "application/xop+xml; type=\"" + soapType + "\"");
        rootPart.setHeader("Content-Transfer-Encoding", "8bit");
        multipart.addBodyPart((BodyPart)rootPart);
        this.addAttachmentParts(multipart);
        this.multipart = multipart;
    }
}

