/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCServerMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderEJB3;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderJSE;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;

public class UnifiedMetaDataDeploymentAspect
extends DeploymentAspect {
    public void start(Deployment dep) {
        UnifiedMetaData umd = (UnifiedMetaData)dep.getAttachment(UnifiedMetaData.class);
        if (umd == null) {
            Object builder;
            if (dep.getType() == Deployment.DeploymentType.JAXRPC_JSE) {
                builder = new JAXRPCServerMetaDataBuilder();
                umd = ((JAXRPCServerMetaDataBuilder)builder).buildMetaData((ArchiveDeployment)dep);
            } else if (dep.getType() == Deployment.DeploymentType.JAXRPC_EJB21) {
                builder = new JAXRPCServerMetaDataBuilder();
                umd = ((JAXRPCServerMetaDataBuilder)builder).buildMetaData((ArchiveDeployment)dep);
            } else if (dep.getType() == Deployment.DeploymentType.JAXWS_JSE) {
                builder = new JAXWSMetaDataBuilderJSE();
                umd = ((JAXWSMetaDataBuilderJSE)builder).buildMetaData((ArchiveDeployment)dep);
            } else if (dep.getType() == Deployment.DeploymentType.JAXWS_EJB3) {
                builder = new JAXWSMetaDataBuilderEJB3();
                umd = ((JAXWSMetaDataBuilderEJB3)builder).buildMetaData((ArchiveDeployment)dep);
            } else {
                throw new IllegalStateException("Invalid deployment type:  " + dep.getType());
            }
            dep.addAttachment(UnifiedMetaData.class, (Object)umd);
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
            if (sepMetaData != null) continue;
            sepMetaData = this.getEndpointMetaData(umd, ep);
            sepMetaData.setEndpoint(ep);
            ep.addAttachment(ServerEndpointMetaData.class, (Object)sepMetaData);
            String targetBean = ep.getTargetBeanName();
            if (targetBean == null) continue;
            sepMetaData.setServiceEndpointImplName(targetBean);
        }
    }

    private ServerEndpointMetaData getEndpointMetaData(UnifiedMetaData umd, Endpoint ep) {
        String epName = ep.getShortName();
        ServerEndpointMetaData epMetaData = null;
        block0: for (ServiceMetaData serviceMetaData : umd.getServices()) {
            for (EndpointMetaData aux : serviceMetaData.getEndpoints()) {
                String linkName = ((ServerEndpointMetaData)aux).getLinkName();
                if (!epName.equals(linkName)) continue;
                epMetaData = (ServerEndpointMetaData)aux;
                continue block0;
            }
        }
        if (epMetaData == null) {
            throw new IllegalStateException("Cannot find endpoint meta data for: " + epName);
        }
        return epMetaData;
    }
}

