/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.LogManager;
import org.jboss.logging.jdk.SecurityActions;
import org.jboss.logging.jdk.xml.DOMConfigurator;

public class JDKLogManager
extends LogManager {
    private static final String DEFAULT_CONFIG_PROPS = "jdklogger.properties";
    private static final String DEFAULT_CONFIG_XML = "jdklogger.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException, SecurityException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String config = SecurityActions.getProperty("java.util.logging.config.file");
        URL configURL = null;
        if (config == null) {
            config = DEFAULT_CONFIG_XML;
            configURL = loader.getResource(DEFAULT_CONFIG_XML);
            if (configURL == null) {
                config = DEFAULT_CONFIG_PROPS;
                configURL = loader.getResource(DEFAULT_CONFIG_PROPS);
            }
            if (configURL == null) {
                config = DEFAULT_CONFIG_XML;
                File test = new File(DEFAULT_CONFIG_XML);
                if (test.exists()) {
                    configURL = test.toURL();
                } else {
                    config = DEFAULT_CONFIG_PROPS;
                    test = new File(DEFAULT_CONFIG_PROPS);
                    if (test.exists()) {
                        configURL = test.toURL();
                    }
                }
                if (configURL == null) {
                    String msg = "No java.util.logging.config.file specified, and neither the default jdklogger.xml or jdklogger.properties was found";
                    throw new FileNotFoundException(msg);
                }
            }
        }
        if (configURL == null) {
            configURL = loader.getResource(config);
        }
        InputStream is = null;
        if (configURL == null) {
            FileInputStream in = new FileInputStream(config);
            is = new BufferedInputStream(in);
        } else {
            is = configURL.openStream();
        }
        boolean isXML = config.endsWith(".xml");
        try {
            if (isXML) {
                DOMConfigurator.configure(is);
            } else {
                super.readConfiguration(is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void reset() {
    }

    public void doReset() {
        super.reset();
    }
}

